% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bcmeta.R
\name{bcmeta}
\alias{bcmeta}
\title{Bias-Corrected Meta-Analysis for Combining Studies of Different Types and Quality}
\usage{
bcmeta(
  data,
  mean.mu = 0,
  sd.mu = 10,
  scale.sigma.between = 0.5,
  df.scale.between = 1,
  B.lower = 0,
  B.upper = 10,
  a.0 = 1,
  a.1 = 1,
  nu = 0.5,
  nu.estimate = FALSE,
  b.0 = 1,
  b.1 = 2,
  nr.chains = 2,
  nr.iterations = 10000,
  nr.adapt = 1000,
  nr.burnin = 1000,
  nr.thin = 1,
  be.quiet = FALSE,
  r2jags = TRUE
)
}
\arguments{
\item{data}{A data frame with at least two columns with the following names:
1) TE = treatment effect,
2) seTE = the standard error of the treatment effect.}

\item{mean.mu}{Prior mean of the overall mean parameter mu, default value is 0.}

\item{sd.mu}{Prior standard deviation of mu, the default value is 10.}

\item{scale.sigma.between}{Prior scale parameter for scale gamma distribution for the
precision between studies. The default value is 0.5.}

\item{df.scale.between}{Degrees of freedom of the scale gamma distribution for the precision between studies.
The default value is 1, which results in a Half Cauchy distribution for the standard
deviation between studies. Larger values e.g. 30 corresponds to a Half Normal distribution.}

\item{B.lower}{Lower bound of the bias parameter B, the default value is 0.}

\item{B.upper}{Upper bound of the bias parameter B, the default value is 10.}

\item{a.0}{Parameter for the prior Beta distribution for the probability of bias. Default value is a0 = 1.}

\item{a.1}{Parameter for the prior Beta distribution for the probability of bias. Default value is a1 = 1.}

\item{nu}{Parameter for the Beta distribution for the quality weights. The default value is nu = 0.5.}

\item{nu.estimate}{If TRUE, then we estimate nu from the data.}

\item{b.0}{If nu.estimate = TRUE, this parameter is the shape parameter of the prior Gamma distribution for nu.}

\item{b.1}{If nu.estimate = TRUE, this parameter is the rate parameter of the prior Gamma distribution for nu.
Note that E(nu) = b.0/b.1 and we need to choose b.0 << b.1.}

\item{nr.chains}{Number of chains for the MCMC computations, default 2.}

\item{nr.iterations}{Number of iterations after adapting the MCMC, default is 10000. Some models may need more iterations.}

\item{nr.adapt}{Number of iterations in the adaptation process, defualt is 1000. Some models may need more iterations during adptation.}

\item{nr.burnin}{Number of iteration discared for burnin period, default is 1000. Some models may need a longer burnin period.}

\item{nr.thin}{Thinning rate, it must be a positive integer, the default value 1.}

\item{be.quiet}{Do not print warning message if the model does not adapt. The default value is FALSE. If you are not sure about the adaptation period choose be.quiet=TRUE.}

\item{r2jags}{Which interface is used to link R to JAGS (rjags and R2jags), default value is R2Jags=TRUE.}
}
\value{
This function returns an object of the class "bcmeta". This object contains the MCMC
                           output of each parameter and hyper-parameter in the model and
                           the data frame used for fitting the model.
}
\description{
This function performers a Bayesian meta-analysis to jointly
combine different types of studies. The random-effects follows a finite
mixture of normal distributions.
}
\details{
The results of the object of the class bcmeta can be extracted with R2jags or with rjags. In addition a summary, a print and a plot functions are
implemented for this type of object.
}
\examples{
\dontrun{
library(jarbes)

# Example ppvipd data

data(ppvipd)


}

}
\references{
Verde, P. E. (2017) Two Examples of Bayesian Evidence Synthesis with the Hierarchical Meta-Regression Approach. Chap.9, pag 189-206. Bayesian Inference, ed. Tejedor, Javier Prieto. InTech.

Verde, P.E. (2021) A Bias-Corrected Meta-Analysis Model for Combining Studies of Different Types and Quality. Biometrical Journal; 1–17.
}
