% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auditPrior.R
\name{auditPrior}
\alias{auditPrior}
\title{Prior Distributions for Audit Sampling}
\usage{
auditPrior(method = 'default', likelihood = c('poisson', 'binomial', 'hypergeometric'),
           N.units = NULL, alpha = NULL, beta = NULL, materiality = NULL, expected = 0,
           ir = NULL, cr = NULL, ub = NULL, p.hmin = NULL, x = NULL,
           n = NULL, factor = NULL, conf.level = 0.95)
}
\arguments{
\item{method}{a character specifying the method by which the prior distribution is constructed. Possible options are \code{default}, \code{strict}, \code{impartial}, \code{param}, \code{arm}, \code{bram}, \code{hyp}, \code{sample}, and \code{factor}. See the details section for more information.}

\item{likelihood}{a character specifying the likelihood for updating the prior distribution. Possible options are \code{poisson} (default) for a conjugate gamma prior distribution, \code{binomial} for a conjugate beta prior distribution, or \code{hypergeometric} for a conjugate beta-binomial prior distribution. See the details section for more information.}

\item{N.units}{a numeric value larger than 0 specifying the total number of units in the population. Only used for the \code{hypergeometric} likelihood.}

\item{alpha}{a numeric value specifying the \eqn{\alpha} parameter of the prior distribution. Only used for method \code{param}.}

\item{beta}{a numeric value specifying the \eqn{\beta} parameter of the prior distribution. Only used for method \code{param}.}

\item{materiality}{a numeric value between 0 and 1 specifying the performance materiality (i.e., the maximum tolerable misstatement) as a fraction of the total number of units in the population. Only used for methods \code{impartial}, \code{arm}, and \code{hyp}.}

\item{expected}{a numeric value between 0 and 1 specifying the expected errors in the sample relative to the total sample size. Only used for methods \code{impartial}, \code{arm}, \code{bram}, and \code{hyp}.}

\item{ir}{a numeric value between 0 and 1 specifying the inherent risk in the audit risk model. Only used for method \code{arm}.}

\item{cr}{a numeric value between 0 and 1 specifying the internal control risk in the audit risk model. Only used for method \code{arm}.}

\item{ub}{a numeric value between 0 and 1 specifying the \code{conf.level}-\% upper bound for the prior distribution as a fraction of the total number of units in the population. Only used for method \code{bram}.}

\item{p.hmin}{a numeric value between 0 and 1 specifying the prior probability of the hypothesis of tolerable misstatement (H1: \eqn{\theta <} materiality). Only used for method \code{hyp}.}

\item{x}{a numeric value larger than, or equal to, 0 specifying the sum of proportional errors (taints) in a prior sample. Only used for methods \code{sample} and \code{factor}.}

\item{n}{a numeric value larger than 0 specifying the sample size of a prior sample. Only used for methods \code{sample} and \code{factor}.}

\item{factor}{a numeric value between 0 and 1 specifying the weight of the prior sample. Only used for method \code{factor}.}

\item{conf.level}{a numeric value between 0 and 1 specifying the confidence level.}
}
\value{
An object of class \code{jfaPrior} containing:

\item{prior}{a string describing the functional form of the prior distribution.}
\item{description}{a list containing a description of the prior distribution, including the parameters of the prior distribution and the implicit sample on which the prior distribution is based.}
\item{statistics}{a list containing statistics of the prior distribution, including the mean, mode, median, and upper bound of the prior distribution.}
\item{specifics}{a list containing specifics of the prior distribution that vary depending on the \code{method}.}
\item{hypotheses}{if \code{materiality} is specified, a list containing information about the hypotheses, including prior probabilities and odds for the hypothesis of tolerable misstatement (H1) and the hypothesis of intolerable misstatement (H0).}
\item{method}{a character indicating the method by which the prior distribution is constructed.}
\item{likelihood}{a character indicating the likelihood of the data.}
\item{materiality}{if \code{materiality} is specified, a numeric value between 0 and 1 giving the materiality used to construct the prior distribution.}
\item{expected}{a numeric value larger than, or equal to, 0 giving the input for the number of expected errors.}
\item{conf.level}{a numeric value between 0 and 1 giving the confidence level.}
\item{N.units}{if \code{N.units} is specified, the number of units in the population.}
}
\description{
\code{auditPrior()} is used to specify a prior distribution for Bayesian audit sampling. The interface allows a complete customization of the prior distribution as well as a formal translation of pre-existing audit information into a prior distribution. \code{auditPrior()} returns an object of class \code{jfaPrior} that can be subsequently used in the \code{planning()} and \code{evaluation()} functions via their \code{prior} argument. Objects with class \code{jfaPrior} can be used with associated \code{summary()} and \code{plot()} methods.

For more details on how to use this function, see the package vignette:
\code{vignette('jfa', package = 'jfa')}
}
\details{
To perform Bayesian audit sampling you must assign a prior probability distribution to the parameter in the model, i.e., the population misstatement \eqn{\theta}.
         The prior distribution can incorporate pre-existing audit information about \eqn{\theta} before seeing a sample, which consequently allows for a more efficient or more accurate estimate of \eqn{\theta}.
         However, the default priors used in \code{jfa} are purposely indifferent towards the individual values of \eqn{\theta} in order to 'let the data speak for themselves'.
         Note that these default priors are a conservative choice of prior since they assume all possible misstatement to be (roughly) equally likely before seeing a data sample.
         It is therefore strongly recommended to construct an informed prior distribution based on pre-existing audit information if possible.

This section elaborates on the available options for the \code{method} argument.

\itemize{
 \item{\code{default}:   This method produces a \emph{gamma(1, 1)}, \emph{beta(1, 1)}, or \emph{beta-binomial(N, 1, 1)} prior distribution. These priors are indifferent towards the possible values of the misstatement.}
 \item{\code{strict}:    This method produces an improper \emph{gamma(1, 0)}, \emph{beta(1, 0)}, or \emph{beta-binomial(N, 1, 0)} prior distribution. These prior distributions exactly match sample sizes and upper limits from classical methods.}
 \item{\code{impartial}: This method produces an impartial prior distribution. These prior distributions assume that tolerable misstatement (\eqn{\theta <} materiality) and intolerable misstatement (\eqn{\theta >} materiality) are equally likely.}
 \item{\code{param}:     This method produces a \code{gamma(alpha, beta)}, \code{beta(alpha, beta)}, or \code{beta-binomial(N, alpha, beta)} prior distribution.}
 \item{\code{hyp}:       This method translates an assessment of the prior probability for tolerable misstatement (\eqn{\theta <} materiality) to a prior distribution.}
 \item{\code{arm}:       This method translates an assessment of inherent risk and internal control risk (Audit Risk Model, Derks et al., 2021) to a prior distribution.}
 \item{\code{bram}:      This method translates an assessment of the expected most likely error and x-\% upper bound to a prior distribution.}
 \item{\code{sample}:    This method translates sampling results from an earlier sample to a prior distribution.}
 \item{\code{factor}:    This method translates and weighs sampling results from an earlier sample to a prior distribution.}
}

This section elaborates on the available likelihoods and corresponding prior distributions for the \code{likelihood} argument.

\itemize{
 \item{\code{poisson}:        The Poisson distribution is an approximation of the binomial distribution. The Poisson distribution is defined as: \deqn{f(\theta, n) = \frac{\lambda^\theta e^{-\lambda}}{\theta!}} The conjugate \emph{gamma(\eqn{\alpha, \beta})} prior has probability density function: \deqn{p(\theta; \alpha, \beta) = \frac{\beta^\alpha \theta^{\alpha - 1} e^{-\beta \theta}}{\Gamma(\alpha)}}}
 \item{\code{binomial}:       The binomial distribution is an approximation of the hypergeometric distribution. The binomial distribution is defined as: \deqn{f(\theta, n, x) = {n \choose x} \theta^x (1 - \theta)^{n - x}} The conjugate \emph{beta(\eqn{\alpha, \beta})} prior has probability density function: \deqn{p(\theta; \alpha, \beta) = \frac{1}{B(\alpha, \beta)} \theta^{\alpha - 1} (1 - \theta)^{\beta - 1}}}
 \item{\code{hypergeometric}: The hypergeometric distribution is defined as: \deqn{f(x, n, K, N) = \frac{{K \choose x} {N - K \choose n - x}}{{N \choose n}}} The conjugate \emph{beta-binomial(\eqn{\alpha, \beta})} prior (Dyer and Pierce, 1993) has probability mass function: \deqn{f(x, n, \alpha, \beta) = {n \choose x} \frac{B(x + \alpha, n - x + \beta)}{B(\alpha, \beta)}} }
}
}
\examples{
# Default uniform beta(1, 1) prior distribution
auditPrior(method = "default", likelihood = "binomial")

# Translate inherent risk (ir) and control risk (cr) to a gamma prior distribution
auditPrior(method = "arm", expected = 0.025, materiality = 0.05, ir = 1, cr = 0.6)

# Impartial beta prior distribution (equal prior probabilities)
auditPrior(method = "impartial", likelihood = "binomial", materiality = 0.05)
}
\references{
Derks, K., de Swart, J., Wagenmakers, E.-J., Wille, J., & Wetzels, R. (2021). JASP for audit: Bayesian tools for the auditing practice. \emph{Journal of Open Source Software}, \emph{6}(68), 2733.

Derks, K., de Swart, J., van Batenburg, P., Wagenmakers, E.-J., & Wetzels, R. (2021). Priors in a Bayesian audit: How integration of existing information into the prior distribution can improve audit transparency and efficiency. \emph{International Journal of Auditing}, \emph{25}(3), 621-636.
}
\seealso{
\code{\link{planning}} \code{\link{selection}} \code{\link{evaluation}} \code{\link{report}}
}
\author{
Koen Derks, \email{k.derks@nyenrode.nl}
}
\keyword{audit}
\keyword{evaluation}
\keyword{planning}
\keyword{prior}
