% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simhash.R
\name{distance}
\alias{distance}
\alias{vector_distance}
\title{Hamming distance of words}
\usage{
distance(codel, coder, jiebar)

vector_distance(codel, coder, jiebar)
}
\arguments{
\item{codel}{For \code{distance}, a Chinese sentence or the path of a text file, 
For \code{vector_distance}, a character vector of segmented words.}

\item{coder}{For \code{distance}, a Chinese sentence or the path of a text file, 
For \code{vector_distance}, a character vector of segmented words.}

\item{jiebar}{jiebaR worker}
}
\description{
This function uses Simhash worker to do keyword extraction and finds 
the keywords from two inputs, and then computes Hamming distance 
between them.
}
\examples{
\dontrun{

words = "hello world"
simhasher = worker("simhash", topn = 1)
simhasher <= words
distance("hello world" , "hello world!" , simhasher)

vector_distance(c("hello","world") , c("hello", "world","!") , simhasher)

}
}
\references{
\url{http://en.wikipedia.org/wiki/Hamming_distance}
}
\seealso{
\code{\link{worker}}
}
\author{
Qin Wenfeng
}
