#' A simulated dataset with time-varying longitudinal outcome and covariates.
#'
#' A simulated dataset with time-varying longitudinal outcome,
#'  time-to-event, and time-varying covariates.
#'  The dataset is already converted into left-truncated right-censored (LTRC) format,
#'  so that the Cox model with time-varying longitudinal outcome as a covariate can be fit.
#'  See, for example, Fu and Simonoff (2017).
#'
#' @format A data frame with 866 rows and 11 variables. 
#'  The variables are as follows:
#' \describe{
#' \item{ID}{subject identifier (1 - 500)}
#' \item{X1}{continuous covariate between 0 and 1; time-varying}
#' \item{X2}{continuous covariate between 0 and 1; time-varying}
#' \item{X3}{binary covariate; time-varying}
#' \item{X4}{continuous covariate between 0 and 1; time-varying}
#' \item{X5}{categorical covariate taking values from {1, 2, 3, 4, 5}; time-varying}
#' \item{time_L}{left-truncated time}
#' \item{time_Y}{right-censored time}
#' \item{delta}{censoring indicator, 1 if censored and 0 otherwise}
#' \item{y}{longitudinal outcome; time-varying}
#' \item{g}{true latent class identifier {1, 2, 3, 4}, which is determined by 
#'  the outcomes of \eqn{1\{X1 > 0.5\}} and \eqn{1\{X2 > 0.5\}}, with some noise}
#'  }
#'
#' @examples  
#' # The data for the first five subjects (ID = 1 - 5):
#' #
#' #  ID   X1   X2 X3  X4 X5     time_L   time_Y delta          y g
#' #   1 0.27 0.53  0 0.0  4 0.09251632 1.536030     0 -0.2191137 1
#' #   1 0.49 0.71  1 0.0  5 1.53603028 4.366769     1  0.6429496 2
#' #   2 0.37 0.68  1 0.4  4 0.44674406 1.203560     0  0.5473454 2
#' #   2 0.65 0.67  0 0.2  5 1.20355968 1.330767     1  1.5515773 4
#' #   3 0.57 0.38  0 0.2  4 0.82944637 1.267248     0  1.1410397 3
#' #   3 0.79 0.19  1 0.4  4 1.26724819 5.749602     1  1.0888787 3
#' #   4 0.91 0.95  0 0.9  1 0.81237396 1.807741     1  2.2105303 4
#' #   5 0.20 0.12  1 0.3  5 0.80510669 1.029981     0 -0.1167814 1
#' #   5 0.02 0.31  0 0.4  5 1.02998145 6.404183     1 -0.1747389 1
#' @docType data
#' @keywords data
#' @name data_timevar
#' @usage data(data_timevar)
#' @references Fu, W. and Simonoff, J. S. (2017). Survival trees for left-truncated and right-censored data, with application to time-varying covariate data. Biostatistics, 18(2), 352-369.
NULL
