% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_wald.R
\name{get_wald}
\alias{get_wald}
\title{Computes the Wald test statistic.}
\usage{
get_wald(f, data)
}
\arguments{
\item{f}{a two-sided formula of the fitted survival model, with the longitudinal outcome 
being the first covariate on the right side of the formula.}

\item{data}{a data.frame containing covariates in \code{f}.}
}
\value{
The Wald test statistic.
}
\description{
Computes the Wald test statistic.
 Not to be called directly by the user.
}
\examples{
 data(data_timevar);
 f <- Surv(time_L, time_Y, delta)~y+X3+X4+X5;
 get_wald(f, data_timevar);

}
\seealso{
\code{\link{get_node_val}}
}
