% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/joineRMLBig.R
\name{joinRMLBig}
\alias{joinRMLBig}
\title{Joint model for BIG data using joineRML}
\usage{
joinRMLBig(dtlong, dtsurv, longm, survm, samplesize = 50, rd, timeVar, id)
}
\arguments{
\item{dtlong}{longitudinal dataset, which contains id,visit time,longitudinal measurements along with various covariates}

\item{dtsurv}{survival dataset corresponding to the longitudinal dataset, with survival status and survival time}

\item{longm}{model for longitudinal response}

\item{survm}{survival model}

\item{samplesize}{random effect part}

\item{rd}{random effect part}

\item{timeVar}{time variable in longitudinal model, included in the longitudinal data}

\item{id}{name of id column in longitudinal dataset}
}
\value{
returns a list containing various output which are useful for prediction.
}
\description{
function for joint model in BIG DATA using \code{joineRML}
}
\examples{
  \donttest{
##
library(survival)
library(dplyr)
fit4<-joinRMLBig(dtlong=long2,dtsurv = surv2,longm=y~ x7+visit,survm=Surv(time,status)~x1+visit,
rd=~ visit|id,timeVar='visit',samplesize=200,id='id')
P2<-predJRML(model<-fit4,ids<-c(10),dtlong=long2,dtsurv=surv2)
pp1<-plot(P2$plong[[1]])
pp1<-plot(P2$psurv[[1]])
##
   }


}
\references{
Hickey, Graeme L., et al. "joineRML: a joint model and software package for time-to-event and multivariate longitudinal outcomes." BMC medical research methodology 18 (2018): 1-14.
}
\seealso{
\link{jmbayesBig},\link{jmstanBig},\link{jmcsBig}
}
\author{
Atanu Bhattacharjee, Bhrigu Kumar Rajbongshi and Gajendra Kumar Vishwakarma
}
