
# This file is automatically generated, you probably don't want to edit this

descriptivesOptions <- if (requireNamespace('jmvcore')) R6::R6Class(
    "descriptivesOptions",
    inherit = jmvcore::Options,
    public = list(
        initialize = function(
            vars = NULL,
            splitBy = NULL,
            freq = FALSE,
            hist = FALSE,
            dens = FALSE,
            bar = FALSE,
            barCounts = FALSE,
            box = FALSE,
            violin = FALSE,
            dot = FALSE,
            dotType = "jitter",
            qq = FALSE,
            n = TRUE,
            missing = TRUE,
            mean = TRUE,
            median = TRUE,
            mode = FALSE,
            sum = FALSE,
            sd = FALSE,
            variance = FALSE,
            range = FALSE,
            min = TRUE,
            max = TRUE,
            se = FALSE,
            skew = FALSE,
            kurt = FALSE,
            sw = FALSE,
            quart = FALSE,
            pcEqGr = FALSE,
            pcNEqGr = 4, ...) {

            super$initialize(
                package='jmv',
                name='descriptives',
                requiresData=TRUE,
                ...)

            private$..vars <- jmvcore::OptionVariables$new(
                "vars",
                vars,
                takeFromDataIfMissing=TRUE,
                permitted=list(
                    "numeric",
                    "factor",
                    "id"))
            private$..splitBy <- jmvcore::OptionVariables$new(
                "splitBy",
                splitBy,
                suggested=list(
                    "nominal"),
                permitted=list(
                    "factor"),
                default=NULL)
            private$..freq <- jmvcore::OptionBool$new(
                "freq",
                freq,
                default=FALSE)
            private$..hist <- jmvcore::OptionBool$new(
                "hist",
                hist,
                default=FALSE)
            private$..dens <- jmvcore::OptionBool$new(
                "dens",
                dens,
                default=FALSE)
            private$..bar <- jmvcore::OptionBool$new(
                "bar",
                bar,
                default=FALSE)
            private$..barCounts <- jmvcore::OptionBool$new(
                "barCounts",
                barCounts,
                default=FALSE,
                hidden=TRUE)
            private$..box <- jmvcore::OptionBool$new(
                "box",
                box,
                default=FALSE)
            private$..violin <- jmvcore::OptionBool$new(
                "violin",
                violin,
                default=FALSE)
            private$..dot <- jmvcore::OptionBool$new(
                "dot",
                dot,
                default=FALSE)
            private$..dotType <- jmvcore::OptionList$new(
                "dotType",
                dotType,
                options=list(
                    "jitter",
                    "stack"),
                default="jitter")
            private$..qq <- jmvcore::OptionBool$new(
                "qq",
                qq,
                default=FALSE)
            private$..n <- jmvcore::OptionBool$new(
                "n",
                n,
                default=TRUE)
            private$..missing <- jmvcore::OptionBool$new(
                "missing",
                missing,
                default=TRUE)
            private$..mean <- jmvcore::OptionBool$new(
                "mean",
                mean,
                default=TRUE)
            private$..median <- jmvcore::OptionBool$new(
                "median",
                median,
                default=TRUE)
            private$..mode <- jmvcore::OptionBool$new(
                "mode",
                mode,
                default=FALSE)
            private$..sum <- jmvcore::OptionBool$new(
                "sum",
                sum,
                default=FALSE)
            private$..sd <- jmvcore::OptionBool$new(
                "sd",
                sd,
                default=FALSE)
            private$..variance <- jmvcore::OptionBool$new(
                "variance",
                variance,
                default=FALSE)
            private$..range <- jmvcore::OptionBool$new(
                "range",
                range,
                default=FALSE)
            private$..min <- jmvcore::OptionBool$new(
                "min",
                min,
                default=TRUE)
            private$..max <- jmvcore::OptionBool$new(
                "max",
                max,
                default=TRUE)
            private$..se <- jmvcore::OptionBool$new(
                "se",
                se,
                default=FALSE)
            private$..skew <- jmvcore::OptionBool$new(
                "skew",
                skew,
                default=FALSE)
            private$..kurt <- jmvcore::OptionBool$new(
                "kurt",
                kurt,
                default=FALSE)
            private$..sw <- jmvcore::OptionBool$new(
                "sw",
                sw,
                default=FALSE)
            private$..quart <- jmvcore::OptionBool$new(
                "quart",
                quart,
                default=FALSE)
            private$..pcEqGr <- jmvcore::OptionBool$new(
                "pcEqGr",
                pcEqGr,
                default=FALSE)
            private$..pcNEqGr <- jmvcore::OptionInteger$new(
                "pcNEqGr",
                pcNEqGr,
                default=4,
                min=2,
                max=10)

            self$.addOption(private$..vars)
            self$.addOption(private$..splitBy)
            self$.addOption(private$..freq)
            self$.addOption(private$..hist)
            self$.addOption(private$..dens)
            self$.addOption(private$..bar)
            self$.addOption(private$..barCounts)
            self$.addOption(private$..box)
            self$.addOption(private$..violin)
            self$.addOption(private$..dot)
            self$.addOption(private$..dotType)
            self$.addOption(private$..qq)
            self$.addOption(private$..n)
            self$.addOption(private$..missing)
            self$.addOption(private$..mean)
            self$.addOption(private$..median)
            self$.addOption(private$..mode)
            self$.addOption(private$..sum)
            self$.addOption(private$..sd)
            self$.addOption(private$..variance)
            self$.addOption(private$..range)
            self$.addOption(private$..min)
            self$.addOption(private$..max)
            self$.addOption(private$..se)
            self$.addOption(private$..skew)
            self$.addOption(private$..kurt)
            self$.addOption(private$..sw)
            self$.addOption(private$..quart)
            self$.addOption(private$..pcEqGr)
            self$.addOption(private$..pcNEqGr)
        }),
    active = list(
        vars = function() private$..vars$value,
        splitBy = function() private$..splitBy$value,
        freq = function() private$..freq$value,
        hist = function() private$..hist$value,
        dens = function() private$..dens$value,
        bar = function() private$..bar$value,
        barCounts = function() private$..barCounts$value,
        box = function() private$..box$value,
        violin = function() private$..violin$value,
        dot = function() private$..dot$value,
        dotType = function() private$..dotType$value,
        qq = function() private$..qq$value,
        n = function() private$..n$value,
        missing = function() private$..missing$value,
        mean = function() private$..mean$value,
        median = function() private$..median$value,
        mode = function() private$..mode$value,
        sum = function() private$..sum$value,
        sd = function() private$..sd$value,
        variance = function() private$..variance$value,
        range = function() private$..range$value,
        min = function() private$..min$value,
        max = function() private$..max$value,
        se = function() private$..se$value,
        skew = function() private$..skew$value,
        kurt = function() private$..kurt$value,
        sw = function() private$..sw$value,
        quart = function() private$..quart$value,
        pcEqGr = function() private$..pcEqGr$value,
        pcNEqGr = function() private$..pcNEqGr$value),
    private = list(
        ..vars = NA,
        ..splitBy = NA,
        ..freq = NA,
        ..hist = NA,
        ..dens = NA,
        ..bar = NA,
        ..barCounts = NA,
        ..box = NA,
        ..violin = NA,
        ..dot = NA,
        ..dotType = NA,
        ..qq = NA,
        ..n = NA,
        ..missing = NA,
        ..mean = NA,
        ..median = NA,
        ..mode = NA,
        ..sum = NA,
        ..sd = NA,
        ..variance = NA,
        ..range = NA,
        ..min = NA,
        ..max = NA,
        ..se = NA,
        ..skew = NA,
        ..kurt = NA,
        ..sw = NA,
        ..quart = NA,
        ..pcEqGr = NA,
        ..pcNEqGr = NA)
)

descriptivesResults <- if (requireNamespace('jmvcore')) R6::R6Class(
    inherit = jmvcore::Group,
    active = list(
        descriptives = function() private$.items[["descriptives"]],
        frequencies = function() private$.items[["frequencies"]],
        plots = function() private$.items[["plots"]]),
    private = list(),
    public=list(
        initialize=function(options) {
            super$initialize(
                options=options,
                name="",
                title="Descriptives")
            self$add(jmvcore::Table$new(
                options=options,
                name="descriptives",
                title="Descriptives",
                visible="(n || missing || mean || median || mode || sum || sd || variance || range || min || max || se || skew || kurt || quart || pcEqGr)",
                rows=1,
                clearWith=list(
                    "splitBy",
                    "pcNEqGr"),
                columns=list()))
            self$add(jmvcore::Array$new(
                options=options,
                name="frequencies",
                title="Frequencies",
                visible="(freq)",
                items="(vars)",
                template=jmvcore::Table$new(
                    options=options,
                    title="Frequencies of $key",
                    visible="(levels($key))",
                    clearWith=list(
                        "splitBy"),
                    columns=list())))
            self$add(jmvcore::Array$new(
                options=options,
                name="plots",
                title="Plots",
                items="(vars)",
                template=R6::R6Class(
                    inherit = jmvcore::Group,
                    active = list(),
                    private = list(),
                    public=list(
                        initialize=function(options) {
                            super$initialize(
                                options=options,
                                name="undefined",
                                title="($key)")}))$new(options=options)))}))

descriptivesBase <- if (requireNamespace('jmvcore')) R6::R6Class(
    "descriptivesBase",
    inherit = jmvcore::Analysis,
    public = list(
        initialize = function(options, data=NULL, datasetId="", analysisId="", revision=0) {
            super$initialize(
                package = 'jmv',
                name = 'descriptives',
                version = c(1,0,0),
                options = options,
                results = descriptivesResults$new(options=options),
                data = data,
                datasetId = datasetId,
                analysisId = analysisId,
                revision = revision,
                pause = NULL,
                completeWhenFilled = TRUE)
        }))

#' Descriptives
#'
#' Provides a range of descriptive statistics
#'
#' @examples
#' \dontrun{
#' data('mtcars')
#' dat <- mtcars
#'
#' # frequency tables can be provided for factors
#' dat$gear <- as.factor(dat$gear)
#'
#' descriptives(dat, vars = c('mpg', 'cyl', 'disp', 'gear'), freq = TRUE)
#'
#' #
#' #  DESCRIPTIVES
#' #
#' #  Descriptives
#' #  -------------------------------------------
#' #               mpg     cyl     disp    gear
#' #  -------------------------------------------
#' #    N            32      32      32      32
#' #    Missing       0       0       0       0
#' #    Mean       20.1    6.19     231    3.69
#' #    Median     19.2    6.00     196    4.00
#' #    Minimum    10.4    4.00    71.1       3
#' #    Maximum    33.9    8.00     472       5
#' #  -------------------------------------------
#' #
#' #
#' #  FREQUENCIES
#' #
#' #  Frequencies of gear
#' #  --------------------
#' #    Levels    Counts
#' #  --------------------
#' #    3             15
#' #    4             12
#' #    5              5
#' #  --------------------
#' #
#'}
#' @param data the data as a data frame
#' @param vars a vector of strings naming the variables of interest in
#'   \code{data}
#' @param splitBy a vector of strings naming the variables used to split
#'   \code{vars}
#' @param freq \code{TRUE} or \code{FALSE} (default), provide frequency tables
#'   (nominal, ordinal variables only)
#' @param hist \code{TRUE} or \code{FALSE} (default), provide histograms
#'   (continuous variables only)
#' @param dens \code{TRUE} or \code{FALSE} (default), provide density plots
#'   (continuous variables only)
#' @param bar \code{TRUE} or \code{FALSE} (default), provide bar plots
#'   (nominal, ordinal variables only)
#' @param barCounts \code{TRUE} or \code{FALSE} (default), add counts to the
#'   bar plots
#' @param box \code{TRUE} or \code{FALSE} (default), provide box plots
#'   (continuous variables only)
#' @param violin \code{TRUE} or \code{FALSE} (default), provide violin plots
#'   (continuous variables only)
#' @param dot \code{TRUE} or \code{FALSE} (default), provide dot plots
#'   (continuous variables only)
#' @param dotType .
#' @param qq \code{TRUE} or \code{FALSE} (default), provide Q-Q plots
#'   (continuous variables only)
#' @param n \code{TRUE} (default) or \code{FALSE}, provide the sample size
#' @param missing \code{TRUE} (default) or \code{FALSE}, provide the number of
#'   missing values
#' @param mean \code{TRUE} (default) or \code{FALSE}, provide the mean
#' @param median \code{TRUE} (default) or \code{FALSE}, provide the median
#' @param mode \code{TRUE} or \code{FALSE} (default), provide the mode
#' @param sum \code{TRUE} or \code{FALSE} (default), provide the sum
#' @param sd \code{TRUE} or \code{FALSE} (default), provide the standard
#'   deviation
#' @param variance \code{TRUE} or \code{FALSE} (default), provide the variance
#' @param range \code{TRUE} or \code{FALSE} (default), provide the range
#' @param min \code{TRUE} or \code{FALSE} (default), provide the minimum
#' @param max \code{TRUE} or \code{FALSE} (default), provide the maximum
#' @param se \code{TRUE} or \code{FALSE} (default), provide the standard error
#' @param skew \code{TRUE} or \code{FALSE} (default), provide the skewness
#' @param kurt \code{TRUE} or \code{FALSE} (default), provide the kurtosis
#' @param sw \code{TRUE} or \code{FALSE} (default), provide Shapiro-Wilk
#'   p-value
#' @param quart \code{TRUE} or \code{FALSE} (default), provide quartiles
#' @param pcEqGr \code{TRUE} or \code{FALSE} (default), provide quantiles
#' @param pcNEqGr an integer (default: 4) specifying the number of equal
#'   groups
#' @return A results object containing:
#' \tabular{llllll}{
#'   \code{results$descriptives} \tab \tab \tab \tab \tab a table of the descriptive statistics \cr
#'   \code{results$frequencies} \tab \tab \tab \tab \tab an array of frequency tables \cr
#'   \code{results$plots} \tab \tab \tab \tab \tab an array of descriptive plots \cr
#' }
#'
#' Tables can be converted to data frames with \code{asDF} or \code{\link{as.data.frame}}. For example:
#'
#' \code{results$descriptives$asDF}
#'
#' \code{as.data.frame(results$descriptives)}
#'
#' @export
descriptives <- function(
    data,
    vars,
    splitBy = NULL,
    freq = FALSE,
    hist = FALSE,
    dens = FALSE,
    bar = FALSE,
    barCounts = FALSE,
    box = FALSE,
    violin = FALSE,
    dot = FALSE,
    dotType = "jitter",
    qq = FALSE,
    n = TRUE,
    missing = TRUE,
    mean = TRUE,
    median = TRUE,
    mode = FALSE,
    sum = FALSE,
    sd = FALSE,
    variance = FALSE,
    range = FALSE,
    min = TRUE,
    max = TRUE,
    se = FALSE,
    skew = FALSE,
    kurt = FALSE,
    sw = FALSE,
    quart = FALSE,
    pcEqGr = FALSE,
    pcNEqGr = 4) {

    if ( ! requireNamespace('jmvcore'))
        stop('descriptives requires jmvcore to be installed (restart may be required)')

    if (missing(data))
        data <- jmvcore:::marshalData(
            parent.frame(),
            `if`( ! missing(vars), vars, NULL),
            `if`( ! missing(splitBy), splitBy, NULL))

    vars <- `if`( ! missing(vars), vars, colnames(data))
    for (v in splitBy) data[[v]] <- as.factor(data[[v]])

    options <- descriptivesOptions$new(
        vars = vars,
        splitBy = splitBy,
        freq = freq,
        hist = hist,
        dens = dens,
        bar = bar,
        barCounts = barCounts,
        box = box,
        violin = violin,
        dot = dot,
        dotType = dotType,
        qq = qq,
        n = n,
        missing = missing,
        mean = mean,
        median = median,
        mode = mode,
        sum = sum,
        sd = sd,
        variance = variance,
        range = range,
        min = min,
        max = max,
        se = se,
        skew = skew,
        kurt = kurt,
        sw = sw,
        quart = quart,
        pcEqGr = pcEqGr,
        pcNEqGr = pcNEqGr)

    results <- descriptivesResults$new(
        options = options)

    analysis <- descriptivesClass$new(
        options = options,
        data = data)

    analysis$run()

    analysis$results
}
