% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pca.h.R
\name{pca}
\alias{pca}
\title{Principal Component Analysis}
\usage{
pca(
  data,
  vars,
  nFactorMethod = "parallel",
  nFactors = 1,
  minEigen = 1,
  rotation = "varimax",
  hideLoadings = 0.3,
  sortLoadings = FALSE,
  screePlot = FALSE,
  eigen = FALSE,
  factorCor = FALSE,
  factorSummary = FALSE,
  kmo = FALSE,
  bartlett = FALSE
)
}
\arguments{
\item{data}{the data as a data frame}

\item{vars}{a vector of strings naming the variables of interest in
\code{data}}

\item{nFactorMethod}{\code{'parallel'} (default), \code{'eigen'} or
\code{'fixed'}, the way to determine the number of factors}

\item{nFactors}{an integer (default: 1), the number of components in the
model}

\item{minEigen}{a number (default: 1), the minimal eigenvalue for a
component to be included in the model}

\item{rotation}{\code{'none'}, \code{'varimax'} (default),
\code{'quartimax'}, \code{'promax'}, \code{'oblimin'}, or
\code{'simplimax'}, the rotation to use in estimation}

\item{hideLoadings}{a number (default: 0.3), hide loadings below this value}

\item{sortLoadings}{\code{TRUE} or \code{FALSE} (default), sort the factor
loadings by size}

\item{screePlot}{\code{TRUE} or \code{FALSE} (default), show scree plot}

\item{eigen}{\code{TRUE} or \code{FALSE} (default), show eigenvalue table}

\item{factorCor}{\code{TRUE} or \code{FALSE} (default), show factor
correlations}

\item{factorSummary}{\code{TRUE} or \code{FALSE} (default), show factor
summary}

\item{kmo}{\code{TRUE} or \code{FALSE} (default), show Kaiser-Meyer-Olkin
(KMO) measure of sampling adequacy (MSA) results}

\item{bartlett}{\code{TRUE} or \code{FALSE} (default), show Bartlett's test
of sphericity results}
}
\value{
A results object containing:
\tabular{llllll}{
  \code{results$loadings} \tab \tab \tab \tab \tab a table \cr
  \code{results$factorStats$factorSummary} \tab \tab \tab \tab \tab a table \cr
  \code{results$factorStats$factorCor} \tab \tab \tab \tab \tab a table \cr
  \code{results$modelFit$fit} \tab \tab \tab \tab \tab a table \cr
  \code{results$assump$bartlett} \tab \tab \tab \tab \tab a table \cr
  \code{results$assump$kmo} \tab \tab \tab \tab \tab a table \cr
  \code{results$eigen$initEigen} \tab \tab \tab \tab \tab a table \cr
  \code{results$eigen$screePlot} \tab \tab \tab \tab \tab an image \cr
}

Tables can be converted to data frames with \code{asDF} or \code{\link{as.data.frame}}. For example:

\code{results$loadings$asDF}

\code{as.data.frame(results$loadings)}
}
\description{
Principal Component Analysis
}
\examples{
data('iris')

pca(iris, vars = vars(Sepal.Length, Sepal.Width, Petal.Length, Petal.Width))

#
#  PRINCIPAL COMPONENT ANALYSIS
#
#  Component Loadings
#  ----------------------------------------
#                    1         Uniqueness
#  ----------------------------------------
#    Sepal.Length     0.890        0.2076
#    Sepal.Width     -0.460        0.7883
#    Petal.Length     0.992        0.0168
#    Petal.Width      0.965        0.0688
#  ----------------------------------------
#    Note. 'varimax' rotation was used
#

}
