% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_omv.R
\name{read_omv}
\alias{read_omv}
\title{Read files created of the statistical spreadsheet 'jamovi' (www.jamovi.org)}
\usage{
read_omv(
  fleNme = "",
  useFlt = FALSE,
  rmMsVl = FALSE,
  sveAtt = FALSE,
  getSyn = FALSE,
  getHTM = FALSE
)
}
\arguments{
\item{fleNme}{name (incl. path) of the 'jamovi'-file to be read ("FILENAME.omv"; default = "")}

\item{useFlt}{apply filters (remove the lines where the filter is set to 0; default: FALSE)}

\item{rmMsVl}{remove values defined as missing values (replace them with NA; default - FALSE)}

\item{sveAtt}{store attributes that are not required in the data set (if you want to write the same data set using write_omv; default – FALSE)}

\item{getSyn}{extract syntax from the analyses in the 'jamovi'-file and store it in the attribute 'syntax' (default – FALSE)}

\item{getHTM}{store index.html in the attribute 'HTML' (default – FALSE)}
}
\value{
data frame (can be directly used with functions included in the R-package 'jmv' and syntax from 'jamovi'; also compatible with the format of the R-package "foreign")
}
\description{
Read files created of the statistical spreadsheet 'jamovi' (www.jamovi.org)
}
\examples{
\dontrun{
library(jmvReadWrite)
fleOMV = system.file("extdata", "ToothGrowth.omv", package = "jmvReadWrite")
data = read_omv(fleNme = fleOMV, getSyn = TRUE)
# shows the syntax of the analyses from the .omv-file
attr(data, 'syntax')
# runs the command of the first analysis
eval(parse(text=attr(data, 'syntax')[[1]]))
# runs the command of the second analysis and assigns the output from that analysis
# to the variable result2
eval(parse(text=paste0('result2 = ', attr(data, 'syntax')[[2]])))
names(result2)
# → "main"      "assump"    "contrasts" "postHoc"   "emm" (the names of the five output tables)
}

}
