% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{cv.joinet}
\alias{cv.joinet}
\title{Model comparison}
\usage{
cv.joinet(
  Y,
  X,
  family = "gaussian",
  nfolds.ext = 5,
  nfolds.int = 10,
  foldid.ext = NULL,
  foldid.int = NULL,
  type.measure = "deviance",
  alpha.base = 1,
  alpha.meta = 1,
  compare = FALSE,
  mice = FALSE,
  cvpred = FALSE,
  times = FALSE,
  ...
)
}
\arguments{
\item{Y}{outputs\strong{:}
numeric matrix with \eqn{n} rows (samples)
and \eqn{q} columns (variables),
with positive correlation (see details)}

\item{X}{inputs\strong{:}
numeric matrix with \eqn{n} rows (samples)
and \eqn{p} columns (variables)}

\item{family}{distribution\strong{:}
vector of length \eqn{1} or \eqn{q} with entries
\code{"gaussian"}, \code{"binomial"} or \code{"poisson"}}

\item{nfolds.ext}{number of external folds}

\item{nfolds.int}{number of internal folds}

\item{foldid.ext}{external fold identifiers\strong{:}
vector of length \eqn{n} with entries
between \eqn{1} and \code{nfolds.ext};
or \code{NULL}}

\item{foldid.int}{internal fold identifiers\strong{:}
vector of length \eqn{n} with entries
between \eqn{1} and \code{nfolds.int};
or \code{NULL}}

\item{type.measure}{loss function\strong{:}
vector of length \eqn{1} or \eqn{q} with entries
\code{"deviance"}, \code{"class"}, \code{"mse"} or \code{"mae"}
(see \code{\link[glmnet]{cv.glmnet}})}

\item{alpha.base}{elastic net mixing parameter for base learners\strong{:}
numeric between \eqn{0} (ridge) and \eqn{1} (lasso)}

\item{alpha.meta}{elastic net mixing parameter for meta learner\strong{:}
numeric between \eqn{0} (ridge) and \eqn{1} (lasso)}

\item{compare}{experimental arguments\strong{:}
character vector with entries "mnorm", "spls", "mrce",
"sier", "mtps", "rmtl", "gpm" and others
(requires packages \code{spls}, \code{MRCE}, \code{SiER}, \code{MTPS}, \code{RMTL} or \code{GPM})}

\item{mice}{missing data imputation\strong{:}
logical (\code{mice=TRUE} requires package \code{mice})}

\item{cvpred}{return cross-validated predictions: logical}

\item{times}{measure computation time\strong{:}
logical}

\item{...}{further arguments passed to \code{\link[glmnet]{glmnet}}
and \code{\link[glmnet]{cv.glmnet}}}
}
\value{
This function returns a matrix with \eqn{q} columns,
including the cross-validated loss from the univariate models
(\code{base}), the multivariate models (\code{meta}),
and the intercept-only models (\code{none}).
}
\description{
Compares univariate and multivariate regression.
}
\examples{
n <- 50; p <- 100; q <- 3
X <- matrix(rnorm(n*p),nrow=n,ncol=p)
Y <- replicate(n=q,expr=rnorm(n=n,mean=rowSums(X[,1:5])))
cv.joinet(Y=Y,X=X)

\dontrun{
# correlated features
n <- 50; p <- 100; q <- 3
mu <- rep(0,times=p)
Sigma <- 0.90^abs(col(diag(p))-row(diag(p)))
X <- MASS::mvrnorm(n=n,mu=mu,Sigma=Sigma)
mu <- rowSums(X[,sample(seq_len(p),size=5)])
Y <- replicate(n=q,expr=rnorm(n=n,mean=mu))
#Y <- t(MASS::mvrnorm(n=q,mu=mu,Sigma=diag(n)))
cv.joinet(Y=Y,X=X)}

\dontrun{
# other distributions
n <- 50; p <- 100; q <- 3
X <- matrix(rnorm(n*p),nrow=n,ncol=p)
eta <- rowSums(X[,1:5])
Y <- replicate(n=q,expr=rbinom(n=n,size=1,prob=1/(1+exp(-eta))))
cv.joinet(Y=Y,X=X,family="binomial")
Y <- replicate(n=q,expr=rpois(n=n,lambda=exp(scale(eta))))
cv.joinet(Y=Y,X=X,family="poisson")}

\dontrun{
# uncorrelated outcomes
n <- 50; p <- 100; q <- 3
X <- matrix(rnorm(n*p),nrow=n,ncol=p)
y <- rnorm(n=n,mean=rowSums(X[,1:5]))
Y <- cbind(y,matrix(rnorm(n*(q-1)),nrow=n,ncol=q-1))
cv.joinet(Y=Y,X=X)}

\dontrun{
# sparse and dense models
n <- 50; p <- 100; q <- 3
X <- matrix(rnorm(n*p),nrow=n,ncol=p)
Y <- replicate(n=q,expr=rnorm(n=n,mean=rowSums(X[,1:5])))
set.seed(1) # fix folds
cv.joinet(Y=Y,X=X,alpha.base=1) # lasso
set.seed(1)
cv.joinet(Y=Y,X=X,alpha.base=0) # ridge}

}
