## ----echo=FALSE----------------------------------------------------------
knitr::opts_chunk$set(
	comment = "#>",
	collapse = TRUE,
	warning = FALSE,
	message = FALSE
)

## ------------------------------------------------------------------------
library("jqr")

## ------------------------------------------------------------------------
'{"a": 7}' %>% do(.a + 1) %>% peek
'[8,3,null,6]' %>% sortj %>% peek

## ------------------------------------------------------------------------
'{"a": 7}' %>% do(.a + 1) %>% string
'[8,3,null,6]' %>% sortj %>% string

## ------------------------------------------------------------------------
x <- '{"foo": 5, "bar": 7}' %>% select(a = .foo)
combine(x)

## ------------------------------------------------------------------------
x <- '[{"message": "hello", "name": "jenn"}, {"message": "world", "name": "beth"}]'
x %>% index()

## ------------------------------------------------------------------------
'[8,3,null,6]' %>% sortj

## ------------------------------------------------------------------------
'[1,2,3,4]' %>% reverse

## ------------------------------------------------------------------------
'["a","b,c,d","e"]' %>% join
'["a","b,c,d","e"]' %>% join(`;`)

## ------------------------------------------------------------------------
'["fo", "foo", "barfoo", "foobar", "barfoob"]' %>% index %>% endswith(foo)

## ------------------------------------------------------------------------
'["fo", "foo", "barfoo", "foobar", "barfoob"]' %>% index %>% startswith(foo)

## ------------------------------------------------------------------------
'"foobar"' %>% contains("bar")

## ------------------------------------------------------------------------
'[1,2,5,3,5,3,1,3]' %>% uniquej

## ------------------------------------------------------------------------
'[0, false, [], {}, null, "hello"]' %>% types
'[0, false, [], {}, null, "hello", true, [1,2,3]]' %>% types

## ------------------------------------------------------------------------
'[0, false, [], {}, null, "hello"]' %>% index() %>% type(booleans)

## ------------------------------------------------------------------------
str <- '{"foo": 5, "bar": 7}'
str %>% keys()

## ------------------------------------------------------------------------
str %>% del(bar)
str %>% del(foo)

## ------------------------------------------------------------------------
str3 <- '[[0,1], ["a","b","c"]]'
str3 %>% haskey(2)
str3 %>% haskey(1,2)

## ------------------------------------------------------------------------
'{"foo": 5, "bar": 7}' %>% select(a = .foo)

## ------------------------------------------------------------------------
commits %>%
  index() %>%
  select(sha = .sha, name = .commit.committer.name)

## ------------------------------------------------------------------------
'[5,4,2,7]' %>% index() %>% do(. < 4)
'[5,4,2,7]' %>% index() %>% do(. > 4)
'[5,4,2,7]' %>% index() %>% do(. <= 4)
'[5,4,2,7]' %>% index() %>% do(. >= 4)
'[5,4,2,7]' %>% index() %>% do(. == 4)
'[5,4,2,7]' %>% index() %>% do(. != 4)

## ------------------------------------------------------------------------
'9' %>% sqrtj

## ------------------------------------------------------------------------
'3.14159' %>% floorj

## ------------------------------------------------------------------------
'[5,4,2,7]' %>% minj
'[{"foo":1, "bar":14}, {"foo":2, "bar":3}]' %>% minj
'[{"foo":1, "bar":14}, {"foo":2, "bar":3}]' %>% minj(foo)
'[{"foo":1, "bar":14}, {"foo":2, "bar":3}]' %>% minj(bar)

## ------------------------------------------------------------------------
'[5,4,2,7]' %>% maxj
'[{"foo":1, "bar":14}, {"foo":2, "bar":3}]' %>% maxj
'[{"foo":1, "bar":14}, {"foo":2, "bar":3}]' %>% maxj(foo)
'[{"foo":1, "bar":14}, {"foo":2, "bar":3}]' %>% maxj(bar)

