if(!file.exists("../windows/jq/include/jq.h")){
  unlink("../windows", recursive = TRUE)
  url <- if(grepl("aarch", R.version$platform)){
    "https://github.com/r-windows/bundles/releases/download/jq-1.7/jq-1.7-clang-aarch64.tar.xz"
  } else if(getRversion() >= "4.2") {
    "https://github.com/r-windows/bundles/releases/download/jq-1.7/jq-1.7-ucrt-x86_64.tar.xz"
  } else {
    "https://github.com/rwinlib/jq/archive/v1.6.tar.gz"
  }
  download.file(url, basename(url), quiet = TRUE)
  dir.create("../windows", showWarnings = FALSE)
  untar(basename(url), exdir = "../windows", tar = 'internal')
  unlink(basename(url))
  setwd("../windows")
  file.rename(list.files(), 'jq')
}
