% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jrc.R
\name{authorize}
\alias{authorize}
\title{Authorize further message processing}
\usage{
authorize(id = NULL, show = FALSE)
}
\arguments{
\item{id}{ID of the message to be processed. In `jrc` library all stored messages are
give a random ID that consists of 6 letters or numbers. The ID is reported when the
message is stored. To get a list of IDs of all currently stored messages, set this argument
to \code{NULL}.}

\item{show}{If \code{TRUE} information of the message with a given ID will be show before executing
it with a choice to go on with execution, ignore the message (meaning it will be removed from memory) or
do nothing.}
}
\value{
A vector of IDs of all currently stored messages.
}
\description{
`jrc` library allows one to get a full control over the currently running R session from 
a web page. Therefore for security reasons one should manually authorize function calls,
variable assignments or expression evaluations. All the received messages that are not
processed automatically are given an ID and stored. This function executes a command
from a message with a given ID
}
\details{
Expressions has to be always authorized before evaluation. One can specify a list of
variables that can be reassigned automatically and functions that can be called without
authorization.
}
\seealso{
\code{\link{allowFunctions}}, \code{\link{allowVariables}}, \code{\link{sendCommand}},
\code{\link{sendData}}, \code{\link{callFunction}}, \code{\link{limitStorage}}.
}
