% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/box.R
\name{boxServer}
\alias{boxServer}
\title{boxServer: shiny module server for boxplot.}
\usage{
boxServer(id, data, data_label, data_varStruct = NULL, nfactor.limit = 10)
}
\arguments{
\item{id}{id}

\item{data}{Reactive data}

\item{data_label}{Reactive data label}

\item{data_varStruct}{Reactive List of variable structure, Default: NULL}

\item{nfactor.limit}{nlevels limit in factor variable, Default: 10}
}
\value{
Shiny module server for boxplot.
}
\description{
Shiny module server for boxplot.
}
\details{
Shiny module server for boxplot.
}
\examples{
library(shiny)
library(ggplot2)
library(ggpubr)
ui <- fluidPage(
  sidebarLayout(
    sidebarPanel(
      boxUI("box")
    ),
    mainPanel(
      plotOutput("box_plot"),
      ggplotdownUI("box")
    )
  )
)

server <- function(input, output, session) {
  data <- reactive(mtcars)
  data.label <- reactive(jstable::mk.lev(mtcars))

  out_box <- boxServer("box",
    data = data, data_label = data.label,
    data_varStruct = NULL
  )

  output$box_plot <- renderPlot({
    print(out_box())
  })
}
}
