% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gee.R
\name{geeUni}
\alias{geeUni}
\title{geeUni: The coefficient of univariate gee (internal function)}
\usage{
geeUni(y, x, data, id.vec, family, cor.type = "exchangeable")
}
\arguments{
\item{y}{Dependant variable}

\item{x}{Independent variable}

\item{data}{Data}

\item{id.vec}{Vector of id (should be ordered)}

\item{family}{Family: "gaussian", "binomial", "poisson", "quasipoisson", etc...}

\item{cor.type}{Correlation structure, Default: 'exchangeable'}
}
\value{
coefficient, standard error, p-value
}
\description{
Extract the coefficients of univariate gee using geeglm function (geepack package).
}
\details{
DETAILS
}
\examples{
library(geepack)
data(dietox)
dietox$Cu <- as.factor(dietox$Cu)
gee.uni <- geeUni("Weight", "Time",
  data = dietox, id.vec = dietox$Pig,
  family = "gaussian", cor.type = "exchangeable"
)
}
