% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jtdm_predict.R
\name{jtdm_predict}
\alias{jtdm_predict}
\title{Predict method for joint trait distribution model}
\usage{
jtdm_predict(
  m = m,
  Xnew = NULL,
  Ynew = NULL,
  validation = FALSE,
  FullPost = "mean"
)
}
\arguments{
\item{m}{a model fitted with \code{jtdm_fit}}

\item{Xnew}{optionally, a data frame in which to look for variables with which to predict. If omitted, the fitted linear predictors are used}

\item{Ynew}{Optional. The observed response variables at sites specified in Xnew. It is used to compute goodness of fit metrics when validation= T.}

\item{validation}{boolean parameter to decide whether we want to compute goodness of fit measures. If true, then Ynew is needed.}

\item{FullPost}{The type of predictions to be obtain. If FullPost = TRUE, the function returns samples from the predictive distribution, the credible intervals are thus the predictive credible interval. If FullPost="mean", the function computes the posterior distribution of the regression term \eqn{BXnew}), i.e., classical credible intervals. If FullPost=FALSE, the function only returns the posterior mean of the regression term (\eqn{BmeanXnew}), i.e., no credible intervals.}
}
\value{
A list containing:
   \item{Pred}{Sample from the posterior distribution of the posterior predictive distribution. It is an array where the first dimension is the number of sites in Xnew, the second is the number of traits modelled and the third the number of MCMC samples. NULL if FullPost=FALSE.}
   
   \item{PredMean}{Posterior mean of posterior predictive distribution }
   
   \item{Predq975,Predq025}{97.5\% and 0.25\% posterior quantiles of the posterior predictive distribution. NULL if FullPost=FALSE. }
   
   \item{R2}{R squared of predictions (squared Pearson correlation between Ynew and the predictions). NULL if validation=FALSE. }
   
   \item{RMSE}{Root square mean error between  squared of predictions. NULL if validation=FALSE.}
}
\description{
Obtains predictions from a fitted joint trait distribution model and optionally computes their R squared and root mean square error (RMSE)
}
\details{
To obtain a full assessment of the posterior distribution, the function should be ran with FullPost=TRUE, although this can be time consuming. FullPost="mean" is used to compute partial response curves, while FullPost=FALSE is used to compute goodness of fit metrics.
}
\examples{
data(Y)  
data(X)  
m = jtdm_fit(Y = Y, X = X, formula=as.formula("~GDD+FDD+forest"), sample = 1000)
# marginal predictions of traits in the sites of X
pred = jtdm_predict(m)
}
