% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_triang.R
\name{triangulate}
\alias{triangulate}
\alias{triangulate.cpt_list}
\title{Triangulate a Bayesian network}
\usage{
triangulate(
  x,
  root_node = "",
  joint_vars = NULL,
  tri = "min_fill",
  pmf_evidence = NULL,
  alpha = NULL,
  perm = NULL
)

\method{triangulate}{cpt_list}(
  x,
  root_node = "",
  joint_vars = NULL,
  tri = "min_fill",
  pmf_evidence = NULL,
  alpha = NULL,
  perm = NULL
)
}
\arguments{
\item{x}{An object returned from \code{cpt_list} (baeysian network) or
\code{pot_list} (decomposable markov random field)}

\item{root_node}{A node for which we require it to live in the root
clique (the first clique).}

\item{joint_vars}{A vector of variables for which we require them
to be in the same clique. Edges between all these variables are added
to the moralized graph.}

\item{tri}{The optimization strategy used for triangulation if x originates
from a Baeysian network. One of
\itemize{
\item 'min_fill'
\item 'min_rfill'
\item 'min_efill'
\item 'min_sfill'
\item 'min_sp'
\item 'min_esp'
\item 'min_nei'
\item 'minimal'
\item 'alpha'
}}

\item{pmf_evidence}{A named vector of frequencies. The names should
correspond to the evidence that is expected to see over time. Relevant
in connection to \code{min_efill} and \code{min_esp} triangulations.}

\item{alpha}{Character vector. A permutation of the nodes
in the graph. It specifies a user-supplied eliminination ordering for
triangulation of the moral graph.}

\item{perm}{Experimental}
}
\description{
Given a list of CPTs, this function finds a triangulation
}
