% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_compile.R
\name{compile}
\alias{compile}
\alias{compile.cpt_list}
\title{Compile information}
\usage{
compile(
  x,
  evidence = NULL,
  root_node = "",
  joint_vars = NULL,
  tri = "min_fill",
  pmf_evidence = NULL,
  alpha = NULL,
  initialize_cpts = TRUE
)

\method{compile}{cpt_list}(
  x,
  evidence = NULL,
  root_node = "",
  joint_vars = NULL,
  tri = "min_fill",
  pmf_evidence = NULL,
  alpha = NULL,
  initialize_cpts = TRUE
)
}
\arguments{
\item{x}{An object returned from \code{cpt_list} (baeysian network) or
\code{pot_list} (decomposable markov random field)}

\item{evidence}{A named vector. The names are the variabes and the elements
are the evidence.}

\item{root_node}{A node for which we require it to live in the root
clique (the first clique).}

\item{joint_vars}{A vector of variables for which we require them
to be in the same clique. Edges between all these variables are added
to the moralized graph.}

\item{tri}{The optimization strategy used for triangulation if x originates
from a Baeysian network. One of
\itemize{
\item 'min_fill'
\item 'min_rfill'
\item 'min_sp'
\item 'min_ssp'
\item 'min_lsp'
\item 'min_lssp'
\item 'min_elsp'
\item 'min_elssp'
\item 'min_nei'
\item 'minimal'
\item 'alpha'
}}

\item{pmf_evidence}{A named vector of frequencies of the expected
missingness of a variable. Variables with frequencies of 1 can be
neglected; these are inferrred. A value of 0.25 means, that the
given variable is expected to be missing (it is not a evidence node)
in one fourth of the future cases. Relevant for \code{tri} methods
'min_elsp' and 'min_elssp'.}

\item{alpha}{Character vector. A permutation of the nodes
in the graph. It specifies a user-supplied eliminination ordering for
triangulation of the moral graph.}

\item{initialize_cpts}{\code{TRUE} if the CPTs should be initialized,
i.e. multiplied together to form the clique potentials. If FALSE,
the \code{compile}d object will save the triangulation and other
information that needs only bee computed once. Herafter, it is
possible to enter evidence into the CPTs, using \code{set_evidence},
saving a lot of computations.}
}
\description{
Compiled objects are used as building blocks for junction tree inference
}
\details{
The Junction Tree Algorithm performs both a forward and inward
message pass (collect and distribute). However, when the forward
phase is finished, the root clique potential is guaranteed to be the
joint pmf over the variables involved in the root clique. Thus, if
it is known in advance that a specific variable is of interest, the
algortihm can be terminated after the forward phase. Use the \code{root_node}
to specify such a variable and specify \code{propagate = "collect"} in
the juntion tree algortihm function \code{jt}.

Moreover, if interest is in some joint pmf for variables that end up
being in different cliques these variables must be specified in advance
using the \code{joint_vars} argument. The compilation step then
adds edges between all of these variables to ensure that at least one
clique contains all of them.

Evidence can be entered either at compile stage
or after compilation. Hence, one can also combine
evidence from before compilation with evidence
after compilation. Before refers to entering
evidence in the 'compile' function and after
refers to entering evidence in the 'jt' function.

Finally, one can either use a Bayesian network or a decomposable
Markov random field (use the \code{ess} package to fit these). Bayesian
networks must be constructed with \code{cpt_list} and decomposable MRFs
can be constructed with both \code{pot_list} and \code{cpt_list}. However,
\code{pot_list} is just an alias for \code{cpt_list} which handles both
cases internally.
}
\examples{
cptl <- cpt_list(asia2)
cp1  <- compile(cptl, evidence = c(bronc = "yes"), joint_vars = c("bronc", "tub"))
print(cp1)
names(cp1)
dim_names(cp1)
plot(get_graph(cp1))
}
