% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interact_plot.R
\name{effect_plot}
\alias{effect_plot}
\title{Plot simple effects in regression models}
\usage{
effect_plot(model, pred, centered = NULL, standardize = FALSE, n.sd = 1,
  plot.points = FALSE, interval = FALSE, int.type = c("confidence",
  "prediction"), int.width = 0.95, outcome.scale = "response",
  set.offset = 1, x.label = NULL, y.label = NULL, pred.labels = NULL,
  main.title = NULL, color.class = NULL, line.thickness = 1.1)
}
\arguments{
\item{model}{A regression model of type \code{lm}, \code{glm},
\code{\link[survey]{svyglm}}, or \code{\link[lme4]{merMod}}. Models from
other classes may work as well but are not officially supported.}

\item{pred}{The name of the predictor variable you want on the x-axis.}

\item{centered}{A vector of quoted variable names that are to be mean-centered.
If \code{NULL}, all non-focal predictors are centered. If not \code{NULL},
only the user-specified predictors are centered. User can also use "none"
or "all" arguments. The response variable is not centered unless specified
directly.}

\item{standardize}{Logical. Would you like to standardize the variables
that are centered? Default is \code{FALSE}, but if \code{TRUE} it will
standardize variables specified by the \code{centered} argument. Note that
non-focal predictors are centered when \code{centered = NULL}, its default.}

\item{n.sd}{How many standard deviations should be used if \code{standardize
= TRUE}? Default is 1, but some prefer 2.}

\item{plot.points}{Logical. If \code{TRUE}, plots the actual data points as a
scatterplot on top of the interaction lines.}

\item{interval}{Logical. If \code{TRUE}, plots confidence/prediction intervals
the line using \code{\link[ggplot2]{geom_ribbon}}. Not supported for
\code{merMod} models.}

\item{int.type}{Type of interval to plot. Options are "confidence" or
"prediction". Default is confidence interval.}

\item{int.width}{How large should the interval be, relative to the standard error?
The default, .95, corresponds to roughly 1.96 standard errors and a .05 alpha
level for values outside the range. In other words, for a confidence interval,
.95 is analogous to a 95\% confidence interval.}

\item{outcome.scale}{For nonlinear models (i.e., GLMs), should the outcome
variable be plotted on the link scale (e.g., log odds for logit models) or
the original scale (e.g., predicted probabilities for logit models)? The
default is \code{"response"}, which is the original scale. For the link
scale, which will show straight lines rather than curves, use
\code{"link"}.}

\item{set.offset}{For models with an offset (e.g., Poisson models), sets a
offset for the predicted values. All predicted values will have the same
offset. By default, this is set to 1, which makes the predicted values a
proportion.}

\item{x.label}{A character object specifying the desired x-axis label.
If \code{NULL}, the variable name is used.}

\item{y.label}{A character object specifying the desired x-axis label.
If \code{NULL}, the variable name is used.}

\item{pred.labels}{A character vector of 2 labels for the predictor if it is
a 2-level factor or a continuous variable with only 2 values. If \code{NULL},
the default, the factor labels are used.}

\item{main.title}{A character object that will be used as an overall title for the
plot. If \code{NULL}, no main title is used.}

\item{color.class}{Any palette argument accepted by
\code{\link[ggplot2]{scale_colour_brewer}}.}

\item{line.thickness}{How thick should the plotted lines be? Default is 1.1;
ggplot's default is 1.}
}
\value{
The functions returns a \code{ggplot} object, which can be treated like
  a user-created plot and expanded upon as such.
}
\description{
\code{effect_plot()} plots regression paths. The plotting is done with
 \code{ggplot2} rather than base graphics, which some similar functions use.
}
\details{
This function provides a means for plotting effects for the
  purpose of exploring regression estimates. You must have the
  package \code{ggplot2} installed to benefit from these plotting functions.

  By default, all numeric predictors other than the one specified in the
  \code{pred} argument are mean-centered, which usually produces more
  intuitive plots. This only affects the y-axis in linear models, but
  maybe especially important/influential in non-linear/generalized linear
  models.

  This function supports nonlinear and generalized linear models and by
  default will plot them on
  their original scale (\code{outcome.scale = "response"}).

  While mixed effects models from \code{lme4} are supported, only the fixed
  effects are plotted. \code{lme4} does not provide confidence intervals,
  so they are not supported with this function either.

  Note: to use transformed predictors, e.g., \code{log(variable)},
  put its name in quotes or backticks in the argument.
}
\examples{
# Using a fitted lm model
states <- as.data.frame(state.x77)
states$HSGrad <- states$`HS Grad`
fit <- lm(Income ~ HSGrad + Murder,
  data = states)
effect_plot(model = fit, pred = Murder)

# Using interval feature
fit <- lm(accel ~ mag + dist, data=attenu)
effect_plot(fit, pred = mag, interval = TRUE,
  int.type = "confidence", int.width = .8)

# With svyglm
library(survey)
data(api)
dstrat <- svydesign(id=~1,strata=~stype, weights=~pw, data=apistrat, fpc=~fpc)
regmodel <- svyglm(api00~ell + meals, design = dstrat)
effect_plot(regmodel, pred = ell, interval = TRUE)

# With lme4
\dontrun{
library(lme4)
data(VerbAgg)
mv <- glmer(r2 ~ Anger + mode + (1 | item), data = VerbAgg, family = binomial,
            control = glmerControl("bobyqa"))
effect_plot(mv, pred = Anger)
}

}
\seealso{
\code{\link[jtools]{interact_plot}} plots interaction effects,
  producing plots like this function but with separate lines for different
  levels of a moderator.
}
\author{
Jacob Long <\email{long.1377@osu.edu}>
}
