% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tri-wave-model.R
\name{triangle}
\alias{triangle}
\alias{tri.wave.s}
\alias{tri.wave.a}
\alias{tri.wave.y}
\alias{tri.wave.x}
\alias{tri.wave.logr.y}
\alias{tri.wave.logr}
\alias{tri.wave.logr.semi}
\alias{tri.wave.logr.quarter}
\title{Methods of triangular wave model}
\usage{
triangle(t, p)

tri.wave.s(object, t)

tri.wave.a(object, t)

tri.wave.y(object, t)

tri.wave.x(object, t)

tri.wave.logr.y(object, t, p)

tri.wave.logr(object, t, p)

tri.wave.logr.semi(object, t)

tri.wave.logr.quarter(object, t)
}
\arguments{
\item{t}{the time vector in fraction}

\item{p}{the period of the triangle wave}

\item{object}{the object of \code{tri.wave} class}
}
\value{
numeric
}
\description{
Methods of triangular wave model
}
\examples{
  w <- tri.wave()
  t <- seq(1900, 2000, by=1)
  tri.wave.y(w, t)

}
\references{
See Section 4 of Stephen H.T. Lihn, "Jubilee Tectonic Model:
    Forecasting Long-Term Growth and Mean Reversion in the U.S. Stock Market."
    Available at \url{http://dx.doi.org/10.2139/ssrn.3156574}
}
\author{
Stephen H. Lihn
}
\keyword{model}
