% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/juicedown_example.R
\name{juicedown_example}
\alias{juicedown_example}
\title{List example files}
\usage{
juicedown_example(name = NULL, file = NULL)
}
\arguments{
\item{name}{character. A single string for example name.}

\item{file}{character. A single string for the main file.}
}
\value{
character. A list of example files or a path string to each example file.
}
\description{
List example files for the package. Show the path when the exact name is given.
}
\details{
The package sample files are organized under samples directory like so:

samples/
|-- from-html/
|   \code{-- sample.html }-- include/
|-- pic/
`-- sample.Rmd
\itemize{
\item \code{juicedown_example()} is equivalent to \verb{ls samples},
\item \code{juicedown_example("from-html")} is to \verb{ls samples/from-html}, and
\item \code{juicedown_example("from-html", "sample.html")} shows the full path.
}
}
\examples{
juicedown_example()
juicedown_example("from-html")
juicedown_example("from-html", "sample.html")

}
