% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/mcd.R
\docType{methods}
\name{mcd}
\alias{mcd}
\alias{mcd-method}
\alias{mcd,numeric,numeric-method}
\alias{mcd,data.frame,numeric-method}
\alias{mcd,matrix,numeric-method}
\title{Mean Ceramic Date}
\usage{
mcd(object, dates, ...)

\S4method{mcd}{numeric,numeric}(object, dates, calendar = CE())

\S4method{mcd}{data.frame,numeric}(object, dates, calendar = CE())

\S4method{mcd}{matrix,numeric}(object, dates, calendar = CE())
}
\arguments{
\item{object}{A \eqn{m \times p}{m x p} \code{numeric} \code{\link{matrix}} or
\code{\link{data.frame}} of count data (absolute frequencies giving the number of
individuals for each category, i.e. a contingency table). A \code{\link{data.frame}}
will be coerced to a \code{numeric} \code{matrix} via \code{\link[=data.matrix]{data.matrix()}}.}

\item{dates}{A length-\eqn{p} \code{\link{numeric}} vector of dates expressed in years.}

\item{...}{Currently not used.}

\item{calendar}{An \code{\link[aion:TimeScale-class]{aion::TimeScale}} object specifying the calendar
of \code{dates} (see \code{\link[aion:calendar]{aion::calendar()}}). Defaults to Gregorian Common Era.}
}
\value{
A \code{\linkS4class{MeanDate}} object.
}
\description{
Estimates the Mean Ceramic Date of an assemblage.
}
\details{
The Mean Ceramic Date (MCD) is a point estimate of the occupation of an
archaeological site (South 1977). The MCD is estimated as the weighted mean
of the date midpoints of the ceramic types (based on absolute dates or the
known production interval) found in a given assemblage. The weights are the
relative frequencies of the respective types in the assemblage.

A bootstrapping procedure is used to estimate the confidence interval of a
given MCD. For each assemblage, a large number of new bootstrap replicates
is created, with the same sample size, by resampling the original
assemblage with replacement. MCDs are calculated for each replicates and
upper and lower boundaries of the confidence interval associated with each
MCD are then returned.
}
\examples{
## Data from Peeples and Schachner 2012
data("zuni", package = "folio")

## Set the start and end dates for each ceramic type
dates <- list(
  LINO = c(600, 875), KIAT = c(850, 950), RED = c(900, 1050),
  GALL = c(1025, 1125), ESC = c(1050, 1150), PUBW = c(1050, 1150),
  RES = c(1000, 1200), TULA = c(1175, 1300), PINE = c(1275, 1350),
  PUBR = c(1000, 1200), WING = c(1100, 1200), WIPO = c(1125, 1225),
  SJ = c(1200, 1300), LSJ = c(1250, 1300), SPR = c(1250, 1300),
  PINER = c(1275, 1325), HESH = c(1275, 1450), KWAK = c(1275, 1450)
)

## Calculate date midpoints
mid <- vapply(X = dates, FUN = mean, FUN.VALUE = numeric(1))

## Calculate MCD
(mc_dates <- mcd(zuni[100:125, ], dates = mid))

## Get MCD in years CE
time(mc_dates, calendar = CE())

## Plot
plot(mc_dates)

## Bootstrap resampling
boot <- bootstrap(mc_dates, n = 30)
head(boot)

## Jackknife resampling
jack <- jackknife(mc_dates)
head(jack)

## Simulation
sim <- simulate(mc_dates, nsim = 30)
plot(sim, interval = "range", pch = 16)
}
\references{
South, S. A. (1977). \emph{Method and Theory in Historical Archaeology}.
New York: Academic Press.
}
\seealso{
Other mean ceramic date tools: 
\code{\link{plot_mcd}},
\code{\link{resample_mcd}}

Other dating methods: 
\code{\link{event}()}
}
\author{
N. Frerebeau
}
\concept{dating methods}
\concept{mean ceramic date tools}
