% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lkmt.r
\docType{methods}
\name{lkmt_test}
\alias{lkmt_test}
\alias{score_test,matrix-method}
\alias{davies_test,matrix-method}
\title{A function to calculate the p-values for kernel matrices.}
\usage{
lkmt_test(formula, kernel, GWASdata, method = c("satt", "davies"), ...)

\S4method{score_test}{matrix}(x1, x2)

\S4method{davies_test}{matrix}(x1, x2)
}
\arguments{
\item{formula}{The formula to be used for the regression nullmodel.}

\item{kernel}{An object of class \code{kernel} including the pathway 
representing kernel-matrix based on which the test statistic will be calculated.}

\item{GWASdata}{A \code{GWASdata} object stating the data used in analysis.}

\item{method}{A \code{character} specifying which method will be used for 
p-value calculation. Available are \code{'satt'} for the Satterthwaite 
approximation and \code{'davies'} for Davies' algorithm. For more details 
see the references.}

\item{...}{Further arguments can be given to the function.}

\item{x1}{A \code{\link{matrix}} which is the
similarity matrix calculated for the pathway to be tested.}

\item{x2}{An \code{lm} or \code{glm} object of the nullmodel with fixed 
effects covariates included, but no genetic random effects.}
}
\value{
An \code{lkmt} object including the following test results
\itemize{
\item The formula of the regression nullmodel used in the variance 
component test.
\item An object of class \code{\link{kernel}} including the similarity
matrix of the individuals based on which the pathways influence is evaluated.
\item An object of class \code{\link{GWASdata}} stating the data on
which the test was conducted.
\item statistic A \code{vector} giving the value of the variance component
test statistic.
\item df A \code{vector} giving the number of degrees of freedom.
\item p.value A \code{vector} giving the p-value calculated for the pathway
in the variance component test.
}
}
\description{
For parameter \code{'satt'} a pathway's influence on the probability of 
beeing a case is evaluated in the logistic kernel machine test and p-values 
are determined using a Sattherthwaite approximation as described by Dan Schaid.

For parameter \code{'davies'} a pathways influence on the probability
of beeing a case is evaluated using the p-value calculation method described 
by Davies. Here the function \code{\link[CompQuadForm]{davies}} from package 
\pkg{CompQuadForm} is used.
}
\examples{
data(hsa04020)
data(gwas)
net_kernel <- calc_kernel(gwas, hsa04020, knots=NULL, type='net', calculation='cpu')
lkmt_test(pheno ~ sex + age, net_kernel, gwas, method='satt')
}
\references{
For details on the variance component test 
\itemize{
 \item Wu MC, Kraft P, Epstein MP, Taylor DM, Chanock SJ, Hunter DJ, Lin X: Powerful SNP-Set Analysis for Case-Control Genome-Wide Association Studies. Am J Hum Genet 2010, 86:929-42
\item  Liu D, Lin X, Ghosh D: Semiparametric regression of multidimensional genetic pathway data: least-squares kernel machines and linear mixed models. Biometrics 2007, 63(4):1079-88.
}

For details on the p-value calculation see
\itemize{
\item Schaid DJ: Genomic Similarity and Kernel Methods I: Advancements by 
Building on Mathematical and Statistical Foundations. Hum Hered 2010, 70:109-31
}

\itemize{
\item Davies R: Algorithm as 155: the distribution of a linear combination of
     chi-2 random variables. J R Stat Soc Ser C 1980, 29:323-333.
}
}
\author{
Stefanie Friedrichs, Juliane Manitz
}
