% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{fit.keras.engine.training.Model}
\alias{fit.keras.engine.training.Model}
\title{Train a Keras model}
\usage{
\method{fit}{keras.engine.training.Model}(
  object,
  x = NULL,
  y = NULL,
  batch_size = NULL,
  epochs = 10,
  verbose = getOption("keras.fit_verbose", default = "auto"),
  callbacks = NULL,
  view_metrics = getOption("keras.view_metrics", default = "auto"),
  validation_split = 0,
  validation_data = NULL,
  shuffle = TRUE,
  class_weight = NULL,
  sample_weight = NULL,
  initial_epoch = 0,
  steps_per_epoch = NULL,
  validation_steps = NULL,
  ...
)
}
\arguments{
\item{object}{Model to train.}

\item{x}{Vector, matrix, or array of training data (or list if the model has
multiple inputs). If all inputs in the model are named, you can also pass a
list mapping input names to data. \code{x} can be \code{NULL} (default) if feeding
from framework-native tensors (e.g. TensorFlow data tensors). You can also
pass a \code{tfdataset} or a generator returning a list with \verb{(inputs, targets)} or
\verb{(inputs, targets, sample_weights)}.}

\item{y}{Vector, matrix, or array of target (label) data (or list if the model has
multiple outputs). If all outputs in the model are named, you can also pass
a list mapping output names to data. \code{y} can be \code{NULL} (default) if feeding
from framework-native tensors (e.g. TensorFlow data tensors).}

\item{batch_size}{Integer or \code{NULL}. Number of samples per gradient update.
If unspecified, \code{batch_size} will default to 32.}

\item{epochs}{Number of epochs to train the model.
Note that in conjunction with \code{initial_epoch},
\code{epochs} is to be understood as "final epoch". The model is
not trained for a number of iterations given by \code{epochs}, but
merely until the epoch of index \code{epochs} is reached.}

\item{verbose}{Verbosity mode (0 = silent, 1 = progress bar, 2 = one line per
epoch).}

\item{callbacks}{List of callbacks to be called during training.}

\item{view_metrics}{View realtime plot of training metrics (by epoch). The
default (\code{"auto"}) will display the plot when running within RStudio,
\code{metrics} were specified during model \code{\link[=compile]{compile()}}, \code{epochs > 1} and
\code{verbose > 0}. Use the global \code{keras.view_metrics} option to establish a
different default.}

\item{validation_split}{Float between 0 and 1. Fraction of the training data
to be used as validation data. The model will set apart this fraction of
the training data, will not train on it, and will evaluate the loss and any
model metrics on this data at the end of each epoch. The validation data
is selected from the last samples in the \code{x} and \code{y} data provided,
before shuffling.}

\item{validation_data}{Data on which to evaluate the loss and any model
metrics at the end of each epoch. The model will not be trained on this
data. This could be a list (x_val, y_val) or a list (x_val, y_val,
val_sample_weights). \code{validation_data} will override \code{validation_split}.}

\item{shuffle}{shuffle: Logical (whether to shuffle the training data
before each epoch) or string (for "batch"). "batch" is a special option
for dealing with the limitations of HDF5 data; it shuffles in batch-sized
chunks. Has no effect when \code{steps_per_epoch} is not \code{NULL}.}

\item{class_weight}{Optional named list mapping indices (integers) to a
weight (float) value, used for weighting the loss function
(during training only). This can be useful to tell the model to
"pay more attention" to samples from an under-represented class.}

\item{sample_weight}{Optional array of the same length as x, containing
weights to apply to the model's loss for each sample. In the case of
temporal data, you can pass a 2D array with shape (samples,
sequence_length), to apply a different weight to every timestep of every
sample. In this case you should make sure to specify
\code{sample_weight_mode="temporal"} in \code{\link[=compile]{compile()}}.}

\item{initial_epoch}{Integer, Epoch at which to start training (useful for
resuming a previous training run).}

\item{steps_per_epoch}{Total number of steps (batches of samples) before
declaring one epoch finished and starting the next epoch. When training
with input tensors such as TensorFlow data tensors, the default \code{NULL} is
equal to the number of samples in your dataset divided by the batch
size, or 1 if that cannot be determined.}

\item{validation_steps}{Only relevant if \code{steps_per_epoch} is specified.
Total number of steps (batches of samples) to validate before stopping.}

\item{...}{Unused}
}
\value{
A \code{history} object that contains all information collected
during training.
}
\description{
Trains the model for a fixed number of epochs (iterations on a dataset).
}
\seealso{
Other model functions: 
\code{\link{compile.keras.engine.training.Model}()},
\code{\link{evaluate.keras.engine.training.Model}()},
\code{\link{evaluate_generator}()},
\code{\link{fit_generator}()},
\code{\link{get_config}()},
\code{\link{get_layer}()},
\code{\link{keras_model_sequential}()},
\code{\link{keras_model}()},
\code{\link{multi_gpu_model}()},
\code{\link{pop_layer}()},
\code{\link{predict.keras.engine.training.Model}()},
\code{\link{predict_generator}()},
\code{\link{predict_on_batch}()},
\code{\link{predict_proba}()},
\code{\link{summary.keras.engine.training.Model}()},
\code{\link{train_on_batch}()}
}
\concept{model functions}
