% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package.R
\name{use_implementation}
\alias{use_implementation}
\alias{use_backend}
\title{Select a Keras implementation and backend}
\usage{
use_implementation(implementation = c("keras", "tensorflow"))

use_backend(backend = c("tensorflow", "cntk", "theano", "plaidml"))
}
\arguments{
\item{implementation}{One of "keras" or "tensorflow" (defaults to "keras").}

\item{backend}{One of "tensorflow", "cntk", or "theano" (defaults
to "tensorflow")}
}
\description{
Select a Keras implementation and backend
}
\details{
Keras has multiple implementations (the original keras implementation
and the implementation native to TensorFlow) and supports multiple
backends ("tensorflow", "cntk", "theano", and "plaidml"). These functions allow
switching between the various implementations and backends.

The functions should be called after \code{library(keras)} and before calling
other functions within the package (see below for an example).

The default implementation and backend should be suitable for most
use cases. The "tensorflow" implementation is useful when using Keras
in conjunction with TensorFlow Estimators (the \pkg{tfestimators}
R package).
}
\examples{
\dontrun{
# use the tensorflow implementation
library(keras)
use_implementation("tensorflow")

# use the cntk backend
library(keras)
use_backend("theano")
}

}
