% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initializers.R
\name{initializer_orthogonal}
\alias{initializer_orthogonal}
\title{Initializer that generates a random orthogonal matrix.}
\usage{
initializer_orthogonal(gain = 1, seed = NULL)
}
\arguments{
\item{gain}{Multiplicative factor to apply to the orthogonal matrix.}

\item{seed}{Integer used to seed the random generator.}
}
\description{
Initializer that generates a random orthogonal matrix.
}
\section{References}{

Saxe et al., \url{http://arxiv.org/abs/1312.6120}
}

\seealso{
Other initializers: \code{\link{initializer_constant}},
  \code{\link{initializer_glorot_normal}},
  \code{\link{initializer_glorot_uniform}},
  \code{\link{initializer_he_normal}},
  \code{\link{initializer_he_uniform}},
  \code{\link{initializer_identity}},
  \code{\link{initializer_lecun_normal}},
  \code{\link{initializer_lecun_uniform}},
  \code{\link{initializer_ones}},
  \code{\link{initializer_random_normal}},
  \code{\link{initializer_random_uniform}},
  \code{\link{initializer_truncated_normal}},
  \code{\link{initializer_variance_scaling}},
  \code{\link{initializer_zeros}}
}
\concept{initializers}
