% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers-normalization.R
\name{layer_layer_normalization}
\alias{layer_layer_normalization}
\title{Layer normalization layer (Ba et al., 2016).}
\usage{
layer_layer_normalization(
  object,
  axis = -1,
  epsilon = 0.001,
  center = TRUE,
  scale = TRUE,
  beta_initializer = "zeros",
  gamma_initializer = "ones",
  beta_regularizer = NULL,
  gamma_regularizer = NULL,
  beta_constraint = NULL,
  gamma_constraint = NULL,
  trainable = TRUE,
  name = NULL
)
}
\arguments{
\item{object}{What to call the new \code{Layer} instance with. Typically a keras
\code{Model}, another \code{Layer}, or a \code{tf.Tensor}/\code{KerasTensor}. If \code{object} is
missing, the \code{Layer} instance is returned, otherwise, \code{layer(object)} is
returned.}

\item{axis}{Integer or List/Tuple. The axis or axes to normalize across.
Typically this is the features axis/axes. The left-out axes are typically
the batch axis/axes. This argument defaults to -1, the last dimension in
the input.}

\item{epsilon}{Small float added to variance to avoid dividing by zero.
Defaults to 1e-3}

\item{center}{If True, add offset of beta to normalized tensor. If False,
beta is ignored. Defaults to True.}

\item{scale}{If True, multiply by gamma. If False, gamma is not used.
Defaults to True. When the next layer is linear (also e.g. nn.relu), this
can be disabled since the scaling will be done by the next layer.}

\item{beta_initializer}{Initializer for the beta weight. Defaults to zeros.}

\item{gamma_initializer}{Initializer for the gamma weight. Defaults to ones.}

\item{beta_regularizer}{Optional regularizer for the beta weight.
None by default.}

\item{gamma_regularizer}{Optional regularizer for the gamma weight.
None by default.}

\item{beta_constraint}{Optional constraint for the beta weight. None by default.}

\item{gamma_constraint}{Optional constraint for the gamma weight.
None by default.}

\item{trainable}{Boolean, if True the variables will be marked as trainable.
Defaults to True.}

\item{name}{An optional name string for the layer. Should be unique in a
model (do not reuse the same name twice). It will be autogenerated if it
isn't provided.}
}
\description{
Normalize the activations of the previous layer for each given example in a
batch independently, rather than across a batch like Batch Normalization. i.e.
applies a transformation that maintains the mean activation within each example
close to 0 and the activation standard deviation close to 1.
}
\details{
Given a tensor inputs, moments are calculated and normalization is performed
across the axes specified in axis.
}
