% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers-preprocessing.R
\name{layer_random_crop}
\alias{layer_random_crop}
\title{Randomly crop the images to target height and width}
\usage{
layer_random_crop(object, height, width, seed = NULL, ...)
}
\arguments{
\item{object}{What to call the new \code{Layer} instance with. Typically a keras
\code{Model}, another \code{Layer}, or a \code{tf.Tensor}/\code{KerasTensor}. If \code{object} is
missing, the \code{Layer} instance is returned, otherwise, \code{layer(object)} is
returned.}

\item{height}{Integer, the height of the output shape.}

\item{width}{Integer, the width of the output shape.}

\item{seed}{Integer. Used to create a random seed.}

\item{...}{standard layer arguments.}
}
\description{
Randomly crop the images to target height and width
}
\details{
This layer will crop all the images in the same batch to the same cropping
location.
By default, random cropping is only applied during training. At inference
time, the images will be first rescaled to preserve the shorter side, and
center cropped. If you need to apply random cropping at inference time,
set \code{training} to \code{TRUE} when calling the layer.

Input shape:
3D (unbatched) or 4D (batched) tensor with shape:
\verb{(..., height, width, channels)}, in \code{"channels_last"} format.

Output shape:
3D (unbatched) or 4D (batched) tensor with shape:
\verb{(..., target_height, target_width, channels)}.
}
\seealso{
\itemize{
\item \url{https://www.tensorflow.org/api_docs/python/tf/keras/layers/RandomCrop}
\item \url{https://keras.io/api/layers/preprocessing_layers/image_augmentation/random_crop}
}

Other image augmentation layers: 
\code{\link{layer_random_contrast}()},
\code{\link{layer_random_flip}()},
\code{\link{layer_random_height}()},
\code{\link{layer_random_rotation}()},
\code{\link{layer_random_translation}()},
\code{\link{layer_random_width}()},
\code{\link{layer_random_zoom}()}

Other preprocessing layers: 
\code{\link{layer_category_encoding}()},
\code{\link{layer_center_crop}()},
\code{\link{layer_discretization}()},
\code{\link{layer_hashing}()},
\code{\link{layer_integer_lookup}()},
\code{\link{layer_normalization}()},
\code{\link{layer_random_contrast}()},
\code{\link{layer_random_flip}()},
\code{\link{layer_random_height}()},
\code{\link{layer_random_rotation}()},
\code{\link{layer_random_translation}()},
\code{\link{layer_random_width}()},
\code{\link{layer_random_zoom}()},
\code{\link{layer_rescaling}()},
\code{\link{layer_resizing}()},
\code{\link{layer_string_lookup}()},
\code{\link{layer_text_vectorization}()}
}
\concept{image augmentation layers}
\concept{preprocessing layers}
