% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-persistence.R
\name{save_model}
\alias{save_model}
\title{Saves a model as a \code{.keras} file.}
\usage{
save_model(model, filepath = NULL, overwrite = FALSE, zipped = NULL, ...)
}
\arguments{
\item{model}{A keras model.}

\item{filepath}{string,
Path where to save the model. Must end in \code{.keras}.}

\item{overwrite}{Whether we should overwrite any existing model
at the target location, or instead ask the user
via an interactive prompt.}

\item{zipped}{Whether to save the model as a zipped \code{.keras}
archive (default when saving locally), or as an unzipped directory
(default when saving on the Hugging Face Hub).}

\item{...}{For forward/backward compatability.}
}
\value{
If \code{filepath} is provided, then this function is called primarily
for side effects, and \code{model} is returned invisibly. If \code{filepath} is not
provided or \code{NULL}, then the serialized model is returned as an R raw
vector.
}
\description{
Saves a model as a \code{.keras} file.
}
\section{Examples}{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{model <- keras_model_sequential(input_shape = c(3)) |>
  layer_dense(5) |>
  layer_activation_softmax()

model |> save_model("model.keras")
loaded_model <- load_model("model.keras")
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{x <- random_uniform(c(10, 3))
stopifnot(all.equal(
  model |> predict(x),
  loaded_model |> predict(x)
))
}\if{html}{\out{</div>}}

The saved \code{.keras} file is a \code{zip} archive that contains:
\itemize{
\item The model's configuration (architecture)
\item The model's weights
\item The model's optimizer's state (if any)
}

Thus models can be reinstantiated in the exact same state.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{zip::zip_list("model.keras")[, "filename"]
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## [1] "metadata.json"    "config.json"      "model.weights.h5"

}\if{html}{\out{</div>}}
}

\seealso{
\code{\link[=load_model]{load_model()}}

Other saving and loading functions: \cr
\code{\link{export_savedmodel.keras.src.models.model.Model}()} \cr
\code{\link{layer_tfsm}()} \cr
\code{\link{load_model}()} \cr
\code{\link{load_model_weights}()} \cr
\code{\link{register_keras_serializable}()} \cr
\code{\link{save_model_config}()} \cr
\code{\link{save_model_weights}()} \cr
\code{\link{with_custom_object_scope}()} \cr
}
\concept{saving and loading functions}
