% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers.normalization.R
\name{BatchNormalization}
\alias{BatchNormalization}
\title{Batch normalization layer}
\usage{
BatchNormalization(axis = -1, momentum = 0.99, epsilon = 0.001,
  center = TRUE, scale = TRUE, beta_initializer = "zeros",
  gamma_initializer = "ones", moving_mean_initializer = "zeros",
  moving_variance_initializer = "ones", beta_regularizer = NULL,
  gamma_regularizer = NULL, beta_constraint = NULL,
  gamma_constraint = NULL, input_shape = NULL)
}
\arguments{
\item{axis}{Integer, the axis that should be normalized
(typically the features axis).}

\item{momentum}{Momentum for the moving average.}

\item{epsilon}{Small float added to variance to avoid
dividing by zero.}

\item{center}{If True, add offset of beta to normalized
tensor. If False, beta is ignored.}

\item{scale}{If True, multiply by gamma. If False,
gamma is not used. When the next
layer is linear (also e.g. nn.relu),
this can be disabled since the
scaling will be done by the next layer.}

\item{beta_initializer}{Initializer for the beta weight.}

\item{gamma_initializer}{Initializer for the gamma weight.}

\item{moving_mean_initializer}{Initializer for the moving mean.}

\item{moving_variance_initializer}{Initializer for the moving variance.}

\item{beta_regularizer}{Optional regularizer for the beta weight.}

\item{gamma_regularizer}{Optional regularizer for the gamma weight.}

\item{beta_constraint}{Optional constraint for the beta weight.}

\item{gamma_constraint}{Optional constraint for the gamma weight.}

\item{input_shape}{only need when first layer of a model; sets
the input shape of the data}
}
\description{
Batch normalization layer
}
\examples{
if(keras_available()) {
  X_train <- matrix(rnorm(100 * 10), nrow = 100)
  Y_train <- to_categorical(matrix(sample(0:2, 100, TRUE), ncol = 1), 3)
  
  mod <- Sequential()
  mod$add(Dense(units = 50, input_shape = dim(X_train)[2]))
  mod$add(Dropout(rate = 0.5))
  mod$add(Activation("relu"))
  mod$add(BatchNormalization())
  mod$add(Dense(units = 3))
  mod$add(ActivityRegularization(l1 = 1))
  mod$add(Activation("softmax"))
  keras_compile(mod,  loss = 'categorical_crossentropy', optimizer = RMSprop())
  
  keras_fit(mod, X_train, Y_train, batch_size = 32, epochs = 5,
            verbose = 0, validation_split = 0.2)
}
}
\references{
Chollet, Francois. 2015. \href{https://keras.io/}{Keras: Deep Learning library for Theano and TensorFlow}.
}
\seealso{
Other layers: \code{\link{Activation}},
  \code{\link{ActivityRegularization}},
  \code{\link{AdvancedActivation}}, \code{\link{Conv}},
  \code{\link{Dense}}, \code{\link{Dropout}},
  \code{\link{Embedding}}, \code{\link{Flatten}},
  \code{\link{GaussianNoise}}, \code{\link{LayerWrapper}},
  \code{\link{LocallyConnected}}, \code{\link{Masking}},
  \code{\link{MaxPooling}}, \code{\link{Permute}},
  \code{\link{RNN}}, \code{\link{RepeatVector}},
  \code{\link{Reshape}}, \code{\link{Sequential}}
}
\author{
Taylor B. Arnold, \email{taylor.arnold@acm.org}
}
