% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confusion.R
\name{confusion}
\alias{confusion}
\title{confusion}
\usage{
confusion(object = NULL, y_test = NULL, predictions = NULL,
  return_xtab = NULL, digits = 3)
}
\arguments{
\item{object}{Optional fit object. confusion() assumes object contains holdout/vaidation data as `y_test` and the forecasts/classifications as `predictions` but alternative variable names can be specified with the input arguments by those names.}

\item{y_test}{A vector of holdout/validation data or the name in object (if fit object provided but alternative variable name required).}

\item{predictions}{A vector predictions or the name in object (if fit object provided but alternative variable name required).}

\item{return_xtab}{Logical. If TRUE, returns confusion matrix, which is a crosstable with correct predictions on the diagonal (if all levels are predicted at least once). If FALSE, returns data.frame with columns for percent correct, most common misclassification, second most common misclassification, and other predictions. Only defaults to crosstable-style if y_test has fewer than six levels.}

\item{digits}{Number of digits for proportions when return_xtab=FALSE; if NULL, no rounding is performed.}
}
\value{
confusion matrix or table as specified by return_xtab.
}
\description{
Confusion matrix or (for larger number of levels) confusion table.
}
\examples{
mtcars$make <- unlist(lapply(strsplit(rownames(mtcars), " "), function(tokens) tokens[1]))
company <- if(is_keras_available()){
               kms(make ~ ., mtcars, Nepochs=1, verbose=0)
           }else{
                 list(y_test = mtcars$make[1:5], 
                 predictions = sample(mtcars$make, 5))
                 }
confusion(company)     # same as above confusion$company if is_keras_available() == TRUE
confusion(company, return_xtab = FALSE) # focus on pCorrect, most common errors
}
