% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistic.R
\name{pcaLR}
\alias{pcaLR}
\title{generates a closure for the computation of the likelihood ratio statistic
for the kernel PCA prototype.}
\usage{
pcaLR(K, mu = 0, sigma = 1)
}
\arguments{
\item{K}{a single or a list of selected kernel similarity matrices.}

\item{mu}{marginal mean of the response Y}

\item{sigma}{standard deviation of the response}
}
\value{
a closure for the calculation of the LR statistic for the kernel
PCA prototype
}
\description{
This function implements the same prototype statistics in the
\code{\link{ridgeLR}} function, but for kernel principal component regression
(see reference). In our simulations, we observed that this method
underperforms the ridge prototype. The main benefit of this approach is the
possibility of exact post-selection without the need for replicates sampling.
}
\examples{
n <- 30
p <- 20
K <- replicate(5, matrix(rnorm(n*p), nrow = n, ncol = p), simplify = FALSE)
K <-  sapply(K, function(X) return(X \%*\% t(X) / dim(X)[2]), simplify = FALSE)
print(typeof(pcaLR(K, mu = 0, sigma = 1)) == "closure")

}
\references{
Rosipal, R., Girolami, M., Trejo, L. J., & Cichocki, A. (2001).
Kernel PCA for feature extraction and de-noising in nonlinear regression.
Neural Computing and Applications, 10(3), 231–243.
}
\seealso{
Other prototype: \code{\link{ridgeLR}}
}
\concept{prototype}
