% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{key_get}
\alias{key_get}
\alias{key_get_raw}
\alias{key_set}
\alias{key_set_with_value}
\alias{key_set_with_raw_value}
\alias{key_delete}
\alias{key_list}
\title{Operations on keys}
\usage{
key_get(service, username = NULL, keyring = NULL)

key_get_raw(service, username = NULL, keyring = NULL)

key_set(service, username = NULL, keyring = NULL)

key_set_with_value(service, username = NULL, password = NULL, keyring = NULL)

key_set_with_raw_value(
  service,
  username = NULL,
  password = NULL,
  keyring = NULL
)

key_delete(service, username = NULL, keyring = NULL)

key_list(service = NULL, keyring = NULL)
}
\arguments{
\item{service}{Service name, a character scalar.}

\item{username}{Username, a character scalar, or \code{NULL} if the key
is not associated with a username.}

\item{keyring}{For systems that support multiple keyrings, specify
the name of the keyring to use here. If \code{NULL}, then the default
keyring is used. See also \code{\link[=has_keyring_support]{has_keyring_support()}}.}

\item{password}{The secret to store. For \code{key_set}, it is read from
the console, interactively. \code{key_set_with_value} can be also used
in non-interactive mode.}
}
\value{
\code{key_get} returns a character scalar, the password or other
confidential information that was stored in the key.

\code{key_list} returns a list of keys, i.e. service names and usernames,
in a data frame.
}
\description{
These functions manipulate keys in a keyring. You can think of a keyring
as a secure key-value store.
}
\details{
\code{key_get} queries a key from the keyring.

\code{key_get_raw} queries a key and returns it as a raw vector.
Most credential stores allow storing a byte sequence with embedded null
bytes, and these cannot be represented as traditional null bytes
terminated strings. If you don't know whether the key contains an
embedded null, it is best to query it with \code{key_get_raw} instead of
\code{key_get}.

\code{key_set} sets a key in the keyring. The contents of the key is read
interactively from the terminal.

\code{key_set_with_value} is the non-interactive pair of \code{key_set}, to set
a key in the keyring.

\code{key_set_raw_with_value} sets a key to a byte sequence from a raw
vector.

\code{key_delete} deletes a key.

\code{key_list} lists all keys of a keyring, or the keys for a certain
service (if \code{service} is not \code{NULL}).
\subsection{Encodings}{

On Windows, if required, an encoding can be specified using either
an R option (\code{keyring.encoding_windows}) or environment variable
(\code{KEYRING_ENCODING_WINDOWS}). This will be applied when both
getting and setting keys. The option takes precedence over the
environment variable, if both are set.

This is reserved primarily for compatibility with keys set with
other software, such as Python's implementation of keyring. For a
list of encodings, use \code{\link[=iconvlist]{iconvlist()}}, although it should be noted
that not \emph{every} encoding can be properly converted, even for
trivial cases. For best results, use UTF-8 if you can.
}
}
\examples{
# These examples use the default keyring, and they are interactive,
# so, we don't run them by default
\dontrun{
key_set("R-keyring-test-service", "donaldduck")
key_get("R-keyring-test-service", "donaldduck")
if (has_keyring_support()) key_list(service = "R-keyring-test-service")
key_delete("R-keyring-test-service", "donaldduck")

## This is non-interactive, assuming that that default keyring
## is unlocked
key_set_with_value("R-keyring-test-service", "donaldduck",
                   password = "secret")
key_get("R-keyring-test-service", "donaldduck")
if (has_keyring_support()) key_list(service = "R-keyring-test-service")
key_delete("R-keyring-test-service", "donaldduck")

## This is interactive using backend_file
## Set variables to be used in keyring
kr_name <- "my_keyring"
kr_service <- "my_database"
kr_username <- "my_username"

## Create a keyring and add an entry using the variables above
kb <- keyring::backend_file$new()
## Prompt for the keyring password, used to unlock keyring
kb$keyring_create(kr_name)
## Prompt for the secret/password to be stored in the keyring
kb$set(kr_service, username=kr_username, keyring=kr_name)
# Lock the keyring
kb$keyring_lock(kr_name)

## The keyring file is stored at ~/.config/r-keyring/ on Linux

## Output the stored password
keyring::backend_file$new()$get(service = kr_service,
  user = kr_username,
  keyring = kr_name)
}
}
