% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proportion_of_values_in_vector.R
\name{proportion_of_values_in_vector}
\alias{proportion_of_values_in_vector}
\title{Proportion of given values in a vector}
\usage{
proportion_of_values_in_vector(values, vector, na.exclude = TRUE)
}
\arguments{
\item{values}{a set of values}

\item{vector}{a numeric or character vector}

\item{na.exclude}{if \code{TRUE}, NA values will be removed both from
\code{vector} and \code{values} before calculation}
}
\description{
Proportion of given values in a vector
}
\examples{
proportion_of_values_in_vector(
  values = 2:3, vector = c(1:3, NA)
)
proportion_of_values_in_vector(
  values = 2:3, vector = c(1:3, NA), na.exclude = FALSE
)
proportion_of_values_in_vector(
  values = c(2:3, NA), vector = c(1:3, NA), na.exclude = FALSE
)
}
