% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forest_plot.R
\name{forest_plot}
\alias{forest_plot}
\title{Forest plot}
\usage{
forest_plot(
  estimates = NULL,
  estimate_ci_ll = NULL,
  estimate_ci_ul = NULL,
  point_size_range = c(2, 10),
  error_bar_size = 1,
  error_bar_tip_height = 0.3,
  weights = NULL,
  diamond_x = NULL,
  diamond_ci_ll = NULL,
  diamond_ci_ul = NULL,
  diamond_height = 1.2,
  diamond_gap_height = 0.3,
  diamond_1_tip_at_top_y = -0.5,
  diamond_colors = "black",
  study_labels = NULL,
  diamond_labels = NULL,
  diamond_label_size = 6,
  diamond_label_hjust = 0,
  diamond_label_fontface = "bold",
  diamond_estimate_label_hjust = 0,
  diamond_estimate_label_size = 6,
  diamond_estimate_label_fontface = "bold",
  round_estimates = 2,
  x_axis_title = "Observed Outcome",
  vline_size = 1,
  vline_intercept = 0,
  vline_type = "dotted",
  study_label_hjust = 0,
  study_label_begin_x = NULL,
  study_label_begin_x_perc = 60,
  study_label_size = 6,
  study_label_fontface = "plain",
  estimate_label_begin_x = NULL,
  estimate_label_begin_x_perc = 25,
  estimate_label_hjust = 0,
  estimate_label_size = 6,
  estimate_label_fontface = "plain",
  x_axis_tick_marks = NULL,
  legend_position = "none",
  plot_margin = NULL
)
}
\arguments{
\item{estimates}{default = NULL}

\item{estimate_ci_ll}{default = NULL}

\item{estimate_ci_ul}{default = NULL}

\item{point_size_range}{default = c(2, 10)}

\item{error_bar_size}{default = 1}

\item{error_bar_tip_height}{default = 0.3}

\item{weights}{default = NULL}

\item{diamond_x}{default = NULL}

\item{diamond_ci_ll}{default = NULL}

\item{diamond_ci_ul}{default = NULL}

\item{diamond_height}{default = 1.2}

\item{diamond_gap_height}{default = 0.3}

\item{diamond_1_tip_at_top_y}{default = -0.5}

\item{diamond_colors}{default = "black"}

\item{study_labels}{default = NULL}

\item{diamond_labels}{default = NULL}

\item{diamond_label_size}{default = 6}

\item{diamond_label_hjust}{default = 0}

\item{diamond_label_fontface}{default = "bold"}

\item{diamond_estimate_label_hjust}{default = 0}

\item{diamond_estimate_label_size}{default = 6}

\item{diamond_estimate_label_fontface}{default = "bold"}

\item{round_estimates}{default = 2}

\item{x_axis_title}{default = "Observed Outcome"}

\item{vline_size}{default = 1}

\item{vline_intercept}{default = 0}

\item{vline_type}{default = "dotted"}

\item{study_label_hjust}{default = 0}

\item{study_label_begin_x}{default = NULL}

\item{study_label_begin_x_perc}{default = 60}

\item{study_label_size}{default = 6}

\item{study_label_fontface}{default = "plain"}

\item{estimate_label_begin_x}{default = NULL}

\item{estimate_label_begin_x_perc}{default = 25}

\item{estimate_label_hjust}{default = 0}

\item{estimate_label_size}{default = 6}

\item{estimate_label_fontface}{default = "plain"}

\item{x_axis_tick_marks}{default = NULL}

\item{legend_position}{default = "none"}

\item{plot_margin}{default = NULL}
}
\description{
Create a forest plot using outputs from 'metafor' package
}
\examples{
\donttest{
forest_plot(
estimates = c(2, 3, 4),
estimate_ci_ll = c(1, 2, 3),
estimate_ci_ul = c(3, 4, 6),
weights = 1:3,
diamond_x = 2,
diamond_labels = "RE",
diamond_ci_ll = 1.8,
diamond_ci_ul = 2.2,
estimate_label_begin_x_perc = 40,
x_axis_tick_marks = seq(-2, 6, 2))
}
}
