% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlation_matrix.R
\name{correlation_matrix}
\alias{correlation_matrix}
\title{correlation matrix}
\usage{
correlation_matrix(
  data = NULL,
  var_names = NULL,
  row_var_names = NULL,
  col_var_names = NULL,
  round_r = 2,
  round_p = 3,
  output_type = "rp",
  numbered_cols = NULL
)
}
\arguments{
\item{data}{a data object (a data frame or a data.table)}

\item{var_names}{names of the variables for which to calculate
all pairwise correlations}

\item{row_var_names}{names of the variables that will go on the rows
of the correlation matrix}

\item{col_var_names}{names of the variables that will go on the columns
of the correlation matrix}

\item{round_r}{number of decimal places to which to round
correlation coefficients (default = 2)}

\item{round_p}{number of decimal places to which to round
p-values (default = 3)}

\item{output_type}{which value should be filled in cells of the
correlation matrix? If \code{output_type = "r"}, correlation
coefficients; if \code{output_type = "p"}, p-values;
if \code{output_type = "rp"}, correlation coefficients with
significance symbols based on p-values;
if \code{output_type = "n"}, sizes of the samples used to calculate
the correlation coefficients. By default, \code{output_type = "rp"}}

\item{numbered_cols}{logical. If \code{numbered_cols == TRUE} and
if \code{identical(row_var_names, col_var_names) == TRUE}, then
the columns will be numbered instead of containing variable names.}
}
\value{
the output will be a correlation matrix in a data.table format
}
\description{
Creates a correlation matrix
}
\examples{
correlation_matrix(data = mtcars, var_names = c("mpg", "cyl", "wt"))
correlation_matrix(data = mtcars,
row_var_names = c("mpg", "cyl", "hp"), col_var_names = c("wt", "am"))
correlation_matrix(
data = mtcars, var_names = c("mpg", "cyl", "wt"),
numbered_cols = FALSE)
correlation_matrix(
data = mtcars, var_names = c("mpg", "cyl", "wt"), output_type = "r")
}
