% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_kindist_composite.R
\name{simulate_kindist_composite}
\alias{simulate_kindist_composite}
\title{Simulate kin dispersal distance pairs with composite sigmas}
\usage{
simulate_kindist_composite(
  nsims = 100,
  initsigma = 100,
  breedsigma = 50,
  gravsigma = 50,
  ovisigma = 25,
  dims = 100,
  method = "Gaussian",
  kinship = "FS",
  lifestage = "immature",
  shape = 0.5
)
}
\arguments{
\item{nsims}{(integer) -   number of pairs to simulate}

\item{initsigma}{(numeric) -   size of pre-breeding (axial) sigma}

\item{breedsigma}{(numeric) -   size of breeding (axial) sigma}

\item{gravsigma}{(numeric) -   size of post-breeding (axial) sigma}

\item{ovisigma}{(numeric) -   size of oviposition (axial) sigma}

\item{dims}{(numeric) -   length of sides of (square) simulated site area}

\item{method}{(character) - kernel shape to use: either 'Gaussian', 'Laplace' or 'vgamma' (variance-gamma)}

\item{kinship}{(character)- kin category to simulate: one of PO, FS, HS, AV, GG, HAV, GGG, 1C, 1C1, 2C, GAV, HGAV, H1C H1C1 or H2C}

\item{lifestage}{(lifestage) lifestage at sample collection: either 'immature' or 'ovipositional'}

\item{shape}{(numeric) - value of shape parameter to use with 'vgamma' method. Default 0.5}
}
\value{
returns an object of class \code{KinPairSimulation} containing simulation details and a tibble (tab) of simulation values
}
\description{
Simulate kin dispersal distance pairs with composite sigmas
}
\examples{
simulate_kindist_composite(nsims = 100)
simulate_kindist_composite(
  nsims = 10000, initsigma = 20, breedsigma = 30, gravsigma = 30,
  ovisigma = 12, dims = 500, method = "Laplace", kinship = "1C", lifestage = "immature"
)
}
