% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid_depth.R
\name{grid_depth}
\alias{grid_depth}
\alias{grid_depth.parameters}
\alias{grid_depth.list}
\alias{grid_depth.workflow}
\alias{grid_depth.model_spec}
\alias{grid_depth.param}
\alias{grid_depth.default}
\title{Depth-Aware Grid Generation for Neural Networks}
\usage{
grid_depth(
  x,
  ...,
  n_hlayer = 2L,
  size = 5L,
  type = c("regular", "random", "latin_hypercube", "max_entropy", "audze_eglais"),
  original = TRUE,
  levels = 3L,
  variogram_range = 0.5,
  iter = 1000L
)

\method{grid_depth}{parameters}(
  x,
  ...,
  n_hlayer = 2L,
  size = 5L,
  type = c("regular", "random", "latin_hypercube", "max_entropy", "audze_eglais"),
  original = TRUE,
  levels = 3L,
  variogram_range = 0.5,
  iter = 1000L
)

\method{grid_depth}{list}(
  x,
  ...,
  n_hlayer = 2L,
  size = 5L,
  type = c("regular", "random", "latin_hypercube", "max_entropy", "audze_eglais"),
  original = TRUE,
  levels = 3L,
  variogram_range = 0.5,
  iter = 1000L
)

\method{grid_depth}{workflow}(
  x,
  ...,
  n_hlayer = 2L,
  size = 5L,
  type = c("regular", "random", "latin_hypercube", "max_entropy", "audze_eglais"),
  original = TRUE,
  levels = 3L,
  variogram_range = 0.5,
  iter = 1000L
)

\method{grid_depth}{model_spec}(
  x,
  ...,
  n_hlayer = 2L,
  size = 5L,
  type = c("regular", "random", "latin_hypercube", "max_entropy", "audze_eglais"),
  original = TRUE,
  levels = 3L,
  variogram_range = 0.5,
  iter = 1000L
)

\method{grid_depth}{param}(
  x,
  ...,
  n_hlayer = 2L,
  size = 5L,
  type = c("regular", "random", "latin_hypercube", "max_entropy", "audze_eglais"),
  original = TRUE,
  levels = 3L,
  variogram_range = 0.5,
  iter = 1000L
)

\method{grid_depth}{default}(
  x,
  ...,
  n_hlayer = 2L,
  size = 5L,
  type = c("regular", "random", "latin_hypercube", "max_entropy", "audze_eglais"),
  original = TRUE,
  levels = 3L,
  variogram_range = 0.5,
  iter = 1000L
)
}
\arguments{
\item{x}{A \code{parameters} object, list, workflow, or model spec. Can also be
a single \code{param} object if \code{...} contains additional param objects.}

\item{...}{One or more \code{param} objects (e.g., \code{hidden_neurons()}, \code{epochs()}).
If \code{x} is a \code{parameters} object, \code{...} is ignored. None of the objects can
have \code{unknown()} values.}

\item{n_hlayer}{Integer vector specifying number of hidden layers to generate
(e.g., \code{2:4} for 2, 3, or 4 layers). Default is 2.}

\item{size}{Integer. Number of parameter combinations to generate.}

\item{type}{Character. Type of grid: "regular", "random", "latin_hypercube",
"max_entropy", or "audze_eglais".}

\item{original}{Logical. Should original parameter ranges be used?}

\item{levels}{Integer. Levels per parameter for regular grids.}

\item{variogram_range}{Numeric. Range for audze_eglais design.}

\item{iter}{Integer. Iterations for max_entropy optimization.}
}
\value{
A tibble with list columns for \code{hidden_neurons} and \code{activations},
where each element is a vector of length \code{n_hlayer}.
}
\description{
\code{grid_depth()} extends standard grid generation to support multi-layer
neural network architectures. It creates heterogeneous layer configurations
by generating list columns for \code{hidden_neurons} and \code{activations}.
}
\details{
This function is specifically for \code{{kindling}} models. The \code{n_hlayer} parameter
determines network depth and creates list columns for \code{hidden_neurons} and
\code{activations}, where each element is a vector of length matching the sampled depth.
}
\examples{
\donttest{
library(dials)
library(workflows)
library(tune)

# Method 1: Using parameters()
params = parameters(
    hidden_neurons(c(32L, 128L)),
    activations(c("relu", "elu", "selu")),
    epochs(c(50L, 200L))
)
grid = grid_depth(params, n_hlayer = 2:3, type = "regular", levels = 3)

# Method 2: Direct param objects
grid = grid_depth(
    hidden_neurons(c(32L, 128L)),
    activations(c("relu", "elu")),
    epochs(c(50L, 200L)),
    n_hlayer = 2:3,
    type = "random",
    size = 20
)

# Method 3: From workflow
wf = workflow() |>
    add_model(mlp_kindling(hidden_neurons = tune(), activations = tune())) |>
    add_formula(y ~ .)
grid = grid_depth(wf, n_hlayer = 2:4, type = "latin_hypercube", size = 15)
}

}
