#
# Correlated frailty fit to a few families, with 1 covariate
#  This is bigger than test1 -- total of about 500 subjects, which is
#  getting close to the limit of a full-size kinship matrix
# The data set "cdata" is not sorted in famid order.  This fact is also a part
#  of the test, to make sure that I have the array indexing done right.
#
who  <- (cdata$sex=='F' & !is.na(cdata$parity) & !is.na(cdata$endage))
#
# Get my kmat by subscripting the large (huge) kmat
#  (get some coffee while the next line runs)
kmat <- makekinship(cdata$famid, cdata$gid, cdata$dadid, cdata$momid)
temp <- match(cdata$gid[who], dimnames(kmat)[[1]])
options(bdsmatrixsize=prod(dim(kmat)))
tkmat <- 2* kmat[temp,temp]  #kmat's rows are not in the same order as cdata
                             # so tkmat will not be a bdsmatrix
# 
#   The frailty.kin function requires a full kmat, and that matrix
#    must be in gid order to match the coefficients (generated by a
#    factor statement)
#
fit2a <- coxph(Surv(startage, endage, cancer) ~ parity + 
	      frailty.kin(gid, theta=.6, kmat=tkmat), cdata[who,])

#
# Now, create a block-diagonal version of kmat, for the test
#   We leave the missing paritys in, to test that too.
fit2b <- coxme(Surv(startage, endage, cancer) ~ parity, cdata,
                 subset=(sex=='F'), random=~1|gid, varlist=kmat,
                 variance=.6)
fit2c <-  coxme(Surv(startage, endage, cancer) ~ parity, cdata,
                 subset=(sex=='F'), random=~1|gid, varlist=kmat,
                 variance=.6, sparse.calc=1-fit2b$control$sparse.calc)
aeq(fit2b$var, fit2c$var)

# The frailties won't match up:
#  Fit2a is in "gid" order, fit2b in kmat order
# Because fit2b uses sparse computation, we don't get exactly the same
#  answers.  Check it out using a looser criteria than all.equal.
# The indx1 match depends on the fact that gids in cdata are in the same
#  order as in fit2a, that is, in sorted order
indx1 <- match(cdata$gid[who], names(fit2b$frail))
all(abs(fit2a$coef[-1] - fit2b$frail[indx1]) < 1e-3)
all(abs(fit2a$coef[1] - coef(fit2b)$fixed) < 1e-4)
#plot(fit2a$coef[indx1], fit2b$frail)

# Check that the plik is exactly correct
risk <- fit2b$frail[match(cdata$gid, names(fit2b$frail))] +
        coef(fit2b)$fixed * cdata$parity
tfit <- coxph(Surv(startage, endage, cancer) ~ risk, cdata,
              init=1, iter=0)
aeq(fit2b$loglik[3], tfit$loglik[2] - fit2b$pen)
tpen <- sum(fit2b$frail[indx1] * solve(tkmat, fit2b$frail[indx1]))/(2* .6)
aeq(tpen, fit2b$penalty)

# And the integrated likelihood
# The "zeros" matrix is 0 wherever the bds matrix H isn't present
#
temp <- bdsmatrix(blocksize=fit2b$var@blocksize,
                  blocks=rep(1., length(fit2b$var@blocks)))
zeros <- as.matrix(temp)
zeros <- zeros[indx1, indx1]  # rearrange it to tkmat2 order
det1 <- sum(log(diag(gchol(tkmat))*0.6))
nn <- fit2a$n
tfit <- coxph(Surv(startage, endage, cancer) ~ diag(nn) + parity,
              init=c(fit2b$frail[indx1], coef(fit2b)$fixed), iter=0, 
	      data=cdata[who,],
              x=T)
dt <- coxph.detail(tfit)
udt <- apply(dt$score, 2, sum)
upen <- solve(tkmat, fit2b$frail[indx1])/0.6    #first derivative penalty
aeq(udt - c(upen,0), fit2b$u[c(indx1, nn+1)])    #shows that fit2b$u is correct

idt <- matrix(0,nn+1, nn+1)
for (i in 1:length(dt$time)) idt <- idt + dt$imat[,,i]
hmat  <- idt[1:nn, 1:nn] + solve(tkmat*0.6)
ghmat <- gchol(hmat)

det2a <- sum(log(diag(ghmat)))
hmat2 <- hmat* zeros                   # sparse version
det2b <- sum(log(diag(gchol(hmat2))))
det2c <- sum(log(diag(fit2b$hmat)[1:nn]))
all.equal(det2b, det2c)                #should agree
c("Non-sparse log|H|"=det2a, "Sparse log|H|"= det2c)  #of interest

aeq(fit2b$log[2], fit2b$log[3] - 0.5*(det1 + det2b)) #integrated loglik

rm(ghmat, hmat, det1,  det2a, hmat2, det2b, det2c, fit2b, nn)
rm(idt, who, temp, fit2a, indx1, risk, tfit, zeros, tpen)
