% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KLASS.R
\name{apply_klass}
\alias{apply_klass}
\alias{ApplyKlass}
\title{Match and convert a classification}
\usage{
apply_klass(
  x,
  classification,
  date = NULL,
  variant = NULL,
  correspond = NULL,
  language = "nb",
  output_level = NULL,
  output = "name",
  format = TRUE
)

ApplyKlass(
  x,
  klass,
  date = NULL,
  variant = NULL,
  correspond = NULL,
  language = "nb",
  output_level = NULL,
  output = "name",
  format = TRUE
)
}
\arguments{
\item{x}{Input vector of classification codes. Vector must match "code" column from a call to get_klass().}

\item{classification}{Classification number}

\item{date}{String for the required date of the classification. Format must be "yyyy-mm-dd". For an inverval, provide two dates as a vector. If blank, will default to today's date.}

\item{variant}{The classification variant to fetch (if a variant is wanted).}

\item{correspond}{ID number for target in correspondence table. For correspondence between two dates within the same classification, use correspond = TRUE.}

\item{language}{Default "nb" for Norwegian (Bokmål). Also "nn" (Nynorsk) and "en" (English available for some classifications)}

\item{output_level}{Desired output level}

\item{output}{String describing output. May be "name" (default), "code" or "both".}

\item{format}{Logical for whther to run formatting av input vector x (Default = TRUE), important to check if formatting is in one level.}

\item{klass}{Deprecated; use `classification` instead.}
}
\value{
A vector or data frame is returned with names and/or code of the desired output level.
}
\description{
Match and convert a classification
}
\examples{
data(klassdata)
kommune_names <- apply_klass(
  x = klassdata$kommune,
  classification = 131,
  language = "en",
  format = FALSE
)
}
