% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hooks-html.R, R/hooks-asciidoc.R,
%   R/hooks-latex.R, R/hooks-md.R, R/hooks-rst.R, R/hooks-textile.R
\name{hook_plot_html}
\alias{hook_plot_html}
\alias{hook_plot_asciidoc}
\alias{hook_plot_tex}
\alias{hook_plot_md}
\alias{hook_plot_rst}
\alias{hook_plot_textile}
\title{Default plot hooks for different output formats}
\usage{
hook_plot_html(x, options)

hook_plot_asciidoc(x, options)

hook_plot_tex(x, options)

hook_plot_md(x, options)

hook_plot_rst(x, options)

hook_plot_textile(x, options)
}
\arguments{
\item{x}{the plot filename (a character string)}

\item{options}{a list of the current chunk options}
}
\value{
A character string (code with plot filenames wrapped)
}
\description{
These hook functions define how to mark up graphics output in different
output formats.
}
\details{
Depending on the options passed over, \code{hook_plot_tex} may return the
normal \samp{\\includegraphics{}} command, or \samp{\\input{}} (for tikz
files), or \samp{\\animategraphics{}} (for animations); it also takes many
other options into consideration to align plots and set figure sizes, etc.
Similarly, \code{hook_plot_html}, \code{hook_plot_md} and
\code{hook_plot_rst} return character strings which are HTML, Markdown, reST
code.

In most cases we do not need to call these hooks explicitly, and they were
designed to be used internally. Sometimes we may not be able to record R
plots using \code{\link[grDevices]{recordPlot}}, and we can make use of these
hooks to insert graphics output in the output document; see
\code{\link{hook_plot_custom}} for details.
}
\examples{
# this is what happens for a chunk like this

# <<foo-bar-plot, dev='pdf', fig.align='right'>>=
hook_plot_tex("foo-bar-plot.pdf", opts_chunk$merge(list(fig.align = "right")))

# <<bar, dev='tikz'>>=
hook_plot_tex("bar.tikz", opts_chunk$merge(list(dev = "tikz")))

# <<foo, dev='pdf', fig.show='animate', interval=.1>>=

# 5 plots are generated in this chunk
hook_plot_tex("foo5.pdf", opts_chunk$merge(list(fig.show = "animate", interval = 0.1, 
    fig.cur = 5, fig.num = 5)))
}
\references{
\url{https://yihui.name/knitr/hooks/}
}
\seealso{
\code{\link{hook_plot_custom}}
}
