% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readability.num.R
\name{readability.num}
\alias{readability.num}
\title{Calculate readability}
\usage{
readability.num(txt.features = list(sentences = NULL, words = NULL, letters =
  c(all = 0, l5 = 0, l6 = 0), syllables = c(all = 0, s1 = 0, s2 = 0), punct =
  NULL, all.chars = NULL, prepositions = NULL, conjunctions = NULL, pronouns =
  NULL, foreign = NULL, TTR = NULL, FOG.hard.words = NULL, Bormuth.NOL = NULL,
  Dale.Chall.NOL = NULL, Harris.Jacobson.NOL = NULL, Spache.NOL = NULL),
  index = c("ARI", "Bormuth", "Coleman", "Coleman.Liau", "Dale.Chall",
  "Danielson.Bryan", "Dickes.Steiwer", "DRP", "ELF", "Farr.Jenkins.Paterson",
  "Flesch", "Flesch.Kincaid", "FOG", "FORCAST", "Fucks", "Harris.Jacobson",
  "Linsear.Write", "LIX", "nWS", "RIX", "SMOG", "Spache", "Strain",
  "Traenkle.Bailer", "TRI", "Tuldava", "Wheeler.Smith"), parameters = list(),
  ...)
}
\arguments{
\item{txt.features}{A named list with statistical information on the text,
      or an object of class \code{kRp.readability}
(only its \code{desc} slot will then be used). Valid values are:
\describe{
  \item{\code{sentences}:}{The number of sentences.}
  \item{\code{words}:}{The number of words.}
  \item{\code{letters}:}{A named vector providing the number of letters. Must contain a value called \code{"all"},
    the total number of letters, and several values called \code{"l<digit>"},
      giving the number of words
    with \code{<digit>} letters. To calculate all implemented measures with default parameters,
      you need
    at least the values \code{"l5"} (words with five \emph{or less} letters) and \code{"l6"} (words with six letters).}
  \item{\code{syllables}:}{Similar to \code{letters},
      but providing the number of syllables.  Must contain a value called \code{"all"},
    the total number of syllables, and several values called \code{"s<digit>"},
      giving the number of words
    with \code{<digit>} syllables. To calculate all implemented measures with default parameters,
      you need
    at least the values \code{"s1"} and \code{"s2"}.
    Only needed to calculate measures which need syllable count (see \code{\link[koRpus:readability]{readability}}).}
  \item{\code{punct}:}{The number of punctuation characters. Only needed to calculate \code{"TRI"}.}
  \item{\code{all.chars}:}{The number of all characters (including spaces). Only needed to calculate \code{Danielson.Bryan}.}
  \item{\code{prepositions}:}{The number of prepositions. Only needed to calculate \code{"Coleman"} and \code{"Traenkle.Bailer"}.}
  \item{\code{conjunctions}:}{The number of conjunctions. Only needed to calculate \code{"Traenkle.Bailer"}.}
  \item{\code{pronouns}:}{The number of pronouns. Only needed to calculate \code{"Coleman"}.}
  \item{\code{foreign}:}{The number of foreign words. Only needed to calculate \code{"TRI"}.}
  \item{\code{TTR}:}{The type-token ratio. Only needed to calculate \code{"Dickes.Steiwer"}.}
  \item{\code{FOG.hard.words}:}{The number of hard words,
      counted according to FOG. Only needed to calculate \code{"FOG"}.}
  \item{\code{Bormuth.NOL}:}{Number of words not on the Bormuth word list. Only needed to calculate \code{"Bormuth"}.}
  \item{\code{Dale.Chall.NOL}:}{Number of words not on the Dale-Chall word list. Only needed to calculate \code{"Dale.Chall"}.}
  \item{\code{Harris.Jacobson.NOL}:}{Number of words not on the Harris-Jacobson word list. Only needed to calculate \code{"Harris.Jacobson"}.}
  \item{\code{Spache.NOL}:}{Number of words not on the Spache word list. Only needed to calculate \code{"Spache"}.}
}}

\item{index}{A character vector, indicating which indices should actually be computed.}

\item{parameters}{A named list with magic numbers,
      defining the relevant parameters for each index. If none are given,
the default values are used.}

\item{...}{Additional options, see \code{\link[koRpus:readability]{readability}}.}
}
\description{
This function is a stripped down version of \code{\link[koRpus:readability]{readability}}. It does not analyze text,
but directly takes the values used by the formulae to calculate the readability measures.
}
\examples{
\dontrun{
test.features <- list(
 sentences=18,
 words=556,
 letters=c(all=2918, l1=19, l2=92, l3=74, l4=80, l5=51, l6=49),
 syll=c(all=974, s1=316, s2=116),
 punct=78,
 all.chars=3553,
 prepositions=74,
 conjunctions=18,
 pronouns=9,
 foreign=0,
 TTR=0.5269784,
 Bormuth=192,
 Dale.Chall=192,
 Harris.Jacobson=240,
 Spache=240)

# should not calculate FOG, because FOG.hard.words is missing:
readability.num(test.features, index="all")
}
}

