% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrapper_functions_readability.R
\name{ELF}
\alias{ELF}
\title{Readability: Fang's Easy Listening Formula (ELF)}
\usage{
ELF(txt.file, hyphen = NULL, parameters = c(syll = 1), ...)
}
\arguments{
\item{txt.file}{Either an object of class \code{\link[koRpus:kRp.tagged-class]{kRp.tagged}},
      a character vector which must be be
a valid path to a file containing the text to be analyzed,
      or a list of text features. If the latter, calculation
is done by \code{\link[koRpus:readability.num]{readability.num}}.}

\item{hyphen}{An object of class kRp.hyphen. If \code{NULL},
      the text will be hyphenated automatically.}

\item{parameters}{A numeric vector with named magic numbers,
      defining the relevant parameters for the index.}

\item{...}{Further valid options for the main function,
      see \code{\link[koRpus:readability]{readability}} for details.}
}
\value{
An object of class \code{\link[koRpus:kRp.readability-class]{kRp.readability}}.
}
\description{
This is just a convenient wrapper function for \code{\link[koRpus:readability]{readability}}.
}
\details{
This function calculates Fang's Easy Listening Formula (ELF). In contrast to
\code{\link[koRpus:readability]{readability}},
      which by default calculates all possible indices,
this function will only calculate the index value.
}
\examples{
\dontrun{
  ELF(tagged.text)
}
}
\references{
DuBay, W.H. (2004). \emph{The Principles of Readability}. Costa Mesa: Impact Information.
     WWW: \url{http://www.impact-information.com/impactinfo/readability02.pdf}; 22.03.2011.
}
\keyword{readability}
