% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dir.create.unique.R
\name{dir.create.unique}
\alias{dir.create.unique}
\title{Create a uniquely named directory. Appends number & optionally date to directory
name.}
\usage{
dir.create.unique(path, usedate = TRUE, showWarnings = TRUE,
  recursive = TRUE, mode = "0777")
}
\arguments{
\item{path}{A character string for the base name of the directory.}

\item{usedate}{TRUE or FALSE: Insert YYYYMMDD information?}

\item{showWarnings}{default TRUE. Show warnings? Will be passed on
to dir.create}

\item{recursive}{default TRUE. Will be passed on to dir.create}

\item{mode}{Default permissions on unix-alike systems. Will be
passed on to dir.create}
}
\value{
a character string with the directory name
}
\description{
Checks if the requested directory exists. If so, will create new
directory name. My favorite method is to have the target directory
with a date-based subdirectory, but set usedate as FALSE if you
don't like that. Arguments showWarnings, recursive, and mode are
passed along to R's dir.create, which does the actual work here.
}
\details{
Default response to dir = "../output/" fixes the directory name
like this, "../output/20151118-1/" because usedate is assumed
TRUE. If usedate = FALSE, then output names will be like
"../output-1/", "../output-2/", and so forth.
}
\author{
Paul E Johnson <pauljohn@ku.edu>
}

