% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_labs.R
\name{convert_labs}
\alias{convert_labs}
\title{Convert from Haven-style to labelr Variable Value Labels}
\usage{
convert_labs(data, max.unique.vals = 50)
}
\arguments{
\item{data}{the data.frame with Haven-style vector value label attributes.}

\item{max.unique.vals}{constrains the variables that may receive value labels
to those whose total unique values do not exceed the integer value supplied
to this argument. Note that labelr sets a hard ceiling of 5000 on the total
number of unique value labels that any variable is permitted to have under
any circumstance, as labelr is primarily intended for interactive use with
moderately-sized (<=~1M-row) data.frames.}
}
\value{
a data.frame.
}
\description{
Convert a data.frame with Haven package-style value-labeled variables to a
data.frame with \code{add_val_labs}-style one-to-one, value-labeled variables.
}
\examples{
# convert haven vector value labels to labelr value labels
library(haven)
library(tibble)
x1 <- labelled(1:8, c(good = 1, bad = 5))
x2 <- labelled(1:8, c(good = 1, mediocre = 4, bad = 5, horrible = 8))

# make this a tibble
hdf <- tibble::tibble(x1, x2)
hdf # how it looks

# convert value labels to labelr label values
hdf1 <- convert_labs(hdf)

# show select values of hdf1
head(hdf1)

# show that labelr labels are there for the using
head(use_val_labs(hdf1))

# filter hdf1 using x1's "bad" labelr value label (with flab())
head(flab(hdf1, x1 == "bad"), 3)

# filter hdf1 using x1's "good" value label (with flab())
head(flab(hdf1, x1 == "good"), 3)

# return select rows and columns with slab()
slab(hdf1, x2 \%in\% c("good", 2), x2)
slab(hdf1, x2 \%in\% c("good", 2), x1)

}
