% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transfer_labs.R
\name{transfer_labs}
\alias{transfer_labs}
\title{Transfer Labels from One Variable (Column) Name to Another}
\usage{
transfer_labs(data, from, to)
}
\arguments{
\item{data}{a data.frame.}

\item{from}{the unquoted variable name from which labels will be transferred.
Note, even if the variable itself has been dropped from the data.frame (to
include being renamed), its label attribute meta-data may still be present and
available for use by this function (use \code{get_all_lab_atts()} to see).}

\item{to}{the unquoted name of the variable to which the labels will be
transferred.}
}
\value{
A data.frame.
}
\description{
Note: \code{transfer_labs} searches a data.frame's name.labs and val.labs
attributes and transfers the labels associated with one variable name to
another, so that the first variable no longer has name or value labels
associated with it, and so that whatever name or value labels previously were
associated with it are now associated with the second variable.
}
\details{
Certain non-labelr data management functions will preserve the labelr labels
that are attached to the passed data.frame, but they will not update those
labels to reflect any changes the function makes to the variable(s). For
example, if one were to use dplyr::rename to change the name of a
value-labeled variable from old name "x1" to new name "satisfaction", the
labelr attributes associated with "x1" would not be transferred to label
"satisfaction." \code{transfer_labs} allows one to transfer those labels, dis-
associating them with the old name (here, "x1") and associating them with new
name (here, "satisfaction").
}
\examples{
# make toy demographic (gender, raceth, etc.) data set
set.seed(555)
df <- make_demo_data(n = 1000) # another labelr:: function

# let's add variable VALUE labels for variable "raceth"
df <- add_val_labs(df,
  vars = "raceth", vals = c(1:7),
  labs = c("White", "Black", "Hispanic", "Asian", "AIAN", "Multi", "Other"),
  max.unique.vals = 50
)

df <- add_val1(
  data = df, gender, vals = c(0, 1, 2),
  labs = c("Male", "Female", "Other"), max.unique.vals = 50
)

# let's add variable NAME labels
df <- add_name_labs(df, name.labs = c(
  "age" = "Age in years",
  "raceth" = "racial-ethnic group category",
  "gender" = "gender identity"
))
head(df, 4)
get_name_labs(df)
get_val_labs(df)

df <- dplyr::rename(df, race = raceth) # new name is on left of = sign
df <- dplyr::rename(df, gend = gender) # new name is on left of = sign

head(df, 4)
get_name_labs(df)
get_val_labs(df)

df <- transfer_labs(df, from = raceth, to = race) # labs info transferred from raceth
df <- transfer_labs(df, from = gender, to = gend) # labs info transferred to gend
df <- transfer_labs(df, from = gend, to = nothere) # var nothere does not exist!

head(df, 4)
get_name_labs(df)
get_val_labs(df)
}
