% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_val1.R
\name{add_val1}
\alias{add_val1}
\alias{avl1}
\title{Add or Modify a Single Variable's Value Labels}
\usage{
add_val1(data, var, vals, labs, max.unique.vals = 10, init = FALSE)

avl1(data, var, vals, labs, max.unique.vals = 10, init = FALSE)
}
\arguments{
\item{data}{a data.frame.}

\item{var}{the unquoted name of the variable to which value labels will be
added.}

\item{vals}{a vector of distinct values of the actual variable, each of which
is to be associated with a label supplied to the labs argument in the same
positional order (e.g., vals = c(1,0), labs = c("manual", "automatic") will
associate lab "manual" with val 1 and lab "automatic" with val 0.). Note:
NA and other "irregular" (e.g., NaN, Inf) values all are automatically
assigned the label "NA", and this cannot be overridden. Note that you do not
need to specify all unique vals of var, and you can supply value labels
incrementally, one (or a few, or all) unique vals of var at a time. Once
you've added the value label, it is bound to that value until you drop it
(see \code{drop_val_labs}) or some other action (intentional or otherwise) strips
or overwrites it.}

\item{labs}{a character vector of distinct label values, each of which
is to be associated with exactly one corresponding distinct value (vals
argument element) of the variable identified in the var argument. The
order of labs argument must match that of vals argument entries (e.g., if a
three-element vector of values is supplied to vals, then a three- element
vector of proposed labels must be supplied to labs, and the first value of
vals will get the first label of labs, the second value of vals will get the
second label of labs, etc.). Note: NA and other "irregular" (e.g., NaN, Inf)
values are automatically assigned the label "NA" and may not be assigned
another label.}

\item{max.unique.vals}{\code{add_val1}() will not assign value labels to non-
integer (i.e., decimal-having) numeric variables. The max.unique.vals
argument further constrains the variables that may receive value labels to
those whose total unique values do not exceed the integer value supplied to
this argument. Note that labelr sets a hard ceiling of 5000 on the total
number of unique value labels that any variable is permitted to have under
any circumstance, as labelr is primarily intended for interactive use with
moderately-sized (<=~1M-row) data.frames.}

\item{init}{assign placeholder labels for variables that lack decimals
and meet the max.unique.vals threshold.}
}
\value{
A data.frame, with new name labels added (call \code{get_val_labs} to see
them), other provisional/default labelr label information added, and previous
user-added labelr label information preserved.
}
\description{
Add variable value-specific, descriptive value labels to a data.frame.
}
\details{
\code{add_val1} is intended for associating value labels with binary, nominal, or
ordinal (e.g., integer) variables, where each of a limited number of distinct
values is to be associated one-to-one with a distinct value label. To assign
labels to ranges of numerical variables, see \code{add_quant_labs} (or
\code{add_quant1}). To apply the same label to multiple distinct values of a
variable, see \code{add_m1_lab} or \code{add1m1}.

\code{add_val1} works with other labelr functions (e.g., \code{add_val_labs},
\code{drop_val_labs}, \code{get_val_labs}, \code{use_val_labs}, \code{add_lab_cols}) to
facilitate the creation, accessing, modification, use, or deletion of
variable value labels.

Note 1: \code{add_val1} is a variant of \code{add_val_labs} that allows you to specify
only one var to label at a time but that allows you to pass its name without
quoting it (compare add_val1(mtcars, am) to add_val_labs(mtcars, "am").

Note 2: \code{avl1} is a compact alias for \code{add_val1}: they do the same thing,
and the former is easier to type
}
\examples{
# one variable at a time, mtcars
df <- mtcars
# add value labels
# first, using add_val_labs() -- add_val1() example is below
df <- add_val_labs(
  data = df,
  vars = "carb", # note, vars arg; add_val1() takes var arg
  vals = c(1, 2, 3, 4, 6, 8),
  labs = c(
    "1-carb", "2-carbs",
    "3-carbs", "4-carbs",
    "6-carbs", "8-carbs"
  )
)

# now, using add_val1(), where single var arg can be unquoted (cyl, not "cyl")
# note that this is not add_val_labs();
df <- add_val1(
  data = df,
  var = cyl, # note, var arg, not vars arg
  vals = c(4, 6, 8),
  labs = c(
    "four-cyl",
    "six-cyl",
    "eight-cyl"
  )
)

}
