% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/train.spLearner.R
\name{train.spLearner.matrix}
\alias{train.spLearner.matrix}
\title{Train a spatial prediction and/or interpolation model using Ensemble Machine Learning
from a regression/classification matrix}
\usage{
train.spLearner.matrix(
  observations,
  formulaString,
  covariates,
  SL.library,
  family = stats::gaussian(),
  method = "stack.cv",
  predict.type,
  super.learner,
  subsets = 5,
  lambda = 0.5,
  cov.model = "exponential",
  subsample = 10000,
  parallel = "multicore",
  cell.size,
  id = NULL,
  weights = NULL,
  quantreg = TRUE,
  ...
)
}
\arguments{
\item{observations}{Data frame regression matrix,}

\item{formulaString}{Model formula,}

\item{covariates}{SpatialPixelsDataFrame object,}

\item{SL.library}{List of learners,}

\item{family}{Family e.g. gaussian(),}

\item{method}{Ensemble stacking method (see makeStackedLearner),}

\item{predict.type}{Prediction type 'prob' or 'response',}

\item{super.learner}{Ensemble stacking model usually \code{regr.lm},}

\item{subsets}{Number of subsets for repeated CV,}

\item{lambda}{Target variable transformation for geoR (0.5 or 1),}

\item{cov.model}{Covariance model for variogram fitting,}

\item{subsample}{For large datasets consider random subsetting training data,}

\item{parallel}{Initiate parellel processing,}

\item{cell.size}{Block size for spatial Cross-validation,}

\item{id}{Id column name to control clusters of data,}

\item{weights}{Optional weights (per row) that learners will use to account for variable data quality,}

\item{quantreg}{Fit additional ranger model as meta-learner to allow for derivation of prediction intervals,}

\item{...}{other arguments that can be passed on to \code{mlr::makeStackedLearner},}
}
\value{
Object of class \code{spLearner}
}
\description{
Train a spatial prediction and/or interpolation model using Ensemble Machine Learning
from a regression/classification matrix
}
\author{
\href{https://opengeohub.org/people/tom-hengl}{Tom Hengl}
}
