% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.vgmModel.R
\name{fit.vgmModel,formula,data.frame,SpatialPixelsDataFrame-method}
\alias{fit.vgmModel,formula,data.frame,SpatialPixelsDataFrame-method}
\alias{fit.vgmModel}
\title{Fit variogram using point data}
\usage{
\S4method{fit.vgmModel}{formula,data.frame,SpatialPixelsDataFrame}(
  formulaString.vgm,
  rmatrix,
  predictionDomain,
  cov.model = "exponential",
  dimensions = list("2D", "3D", "2D+T", "3D+T"),
  lambda = 0.5,
  psiR = NULL,
  subsample = nrow(rmatrix),
  ini.var,
  ini.range,
  fix.psiA = FALSE,
  fix.psiR = FALSE,
  ...
)
}
\arguments{
\item{formulaString.vgm}{formula.}

\item{rmatrix}{data.frame with coordinates and values of covariates.}

\item{predictionDomain}{SpatialPixelsDataFrame.}

\item{cov.model}{covariance model type used by the geoR package.}

\item{dimensions}{optional 2D or 3D dimensions.}

\item{lambda}{transformation value used by the geoR package.}

\item{psiR}{range parameter used by the geoR package.}

\item{subsample}{number of subset of original samples.}

\item{ini.var}{initial variance (sill) used by the geoR package.}

\item{ini.range}{initial range parameter used by the geoR package.}

\item{fix.psiA}{setting used by the geoR package.}

\item{fix.psiR}{setting used by the geoR package.}

\item{...}{optional arguments to pass to the geoR package.}
}
\value{
Fitted variogram model
}
\description{
Fit variogram using point data
}
\note{
Extends variogram fitting functionality from the geoR package.
Can be used for 2D or 3D point data sets, with and without trend variables.
Models need to be in the form \code{zinc ~ dist} and only numeric variables are allowed.
Often reports \code{Singular matrix. Covariates may have different orders of magnitude.} if the covariates are perfectly aligned.
}
\examples{
library("geoR")
library(rgdal)
demo(meuse, echo=FALSE)
vgm = fit.vgmModel(zinc~dist, as.data.frame(meuse), meuse.grid["dist"], lambda=1)
plot(variog(vgm$geodata))
lines(vgm$vgm)
}
\author{
\href{https://opengeohub.org/people/tom-hengl}{Tom Hengl}
}
