% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_lsm.R
\name{extract_lsm}
\alias{extract_lsm}
\alias{extract_lsm.RasterLayer}
\alias{extract_lsm.RasterStack}
\alias{extract_lsm.RasterBrick}
\alias{extract_lsm.stars}
\alias{extract_lsm.list}
\title{extract_lsm}
\usage{
extract_lsm(landscape, y, what, metric, name, type, directions,
  consider_boundary, edge_depth, full_name, verbose, progress, ...)

\method{extract_lsm}{RasterLayer}(landscape, y, what = NULL,
  metric = NULL, name = NULL, type = NULL, directions = 8,
  consider_boundary = FALSE, edge_depth = 1, full_name = FALSE,
  verbose = TRUE, progress = FALSE, ...)

\method{extract_lsm}{RasterStack}(landscape, y, what = NULL,
  metric = NULL, name = NULL, type = NULL, directions = 8,
  consider_boundary = FALSE, edge_depth = 1, full_name = FALSE,
  verbose = TRUE, progress = FALSE, ...)

\method{extract_lsm}{RasterBrick}(landscape, y, what = NULL,
  metric = NULL, name = NULL, type = NULL, directions = 8,
  consider_boundary = FALSE, edge_depth = 1, full_name = FALSE,
  verbose = TRUE, progress = FALSE, ...)

\method{extract_lsm}{stars}(landscape, y, what = NULL, metric = NULL,
  name = NULL, type = NULL, directions = 8,
  consider_boundary = FALSE, edge_depth = 1, full_name = FALSE,
  verbose = TRUE, progress = FALSE, ...)

\method{extract_lsm}{list}(landscape, y, what = NULL, metric = NULL,
  name = NULL, type = NULL, directions = 8,
  consider_boundary = FALSE, edge_depth = 1, full_name = FALSE,
  verbose = TRUE, progress = FALSE, ...)
}
\arguments{
\item{landscape}{Raster* Layer, Stack, Brick or a list of rasterLayers.}

\item{y}{Spatial object ( Spatialy*; SpatialPolygons*; SpatialLines; Extent or sf equivalents); two-column matrix/data.frame/tibble or cellnumbers that are used to extract landscapemetrics.}

\item{what}{String indicating what metric to calculate, either "patch" (default) for all patch level metrics or any of the patch metrics functions.}

\item{metric}{Abbreviation of metrics to calculate (e.g. 'area').}

\item{name}{Full name of metrics to calculate (e.g. 'core area').}

\item{type}{Metric types to calculate according to FRAGSTATS grouping (e.g. 'aggregation metric').}

\item{directions}{The number of directions in which patches should be
connected: 4 (rook's case) or 8 (queen's case).}

\item{consider_boundary}{Logical if cells that only neighbour the landscape
boundary should be considered as core}

\item{edge_depth}{Distance (in cells) a cell has the be away from the patch
edge to be considered as core cell}

\item{full_name}{Should the full names of all functions be included in the
tibble.}

\item{verbose}{Print warning message if not sufficient patches are present}

\item{progress}{Print progress report}

\item{...}{Arguments passed to \code{raster::extract}.}
}
\value{
tibble
}
\description{
Extract metrics
}
\details{
This functions extracts the metrics of all patches the spatial object(s) \code{y}
(e.g. spatial points) are located within. Only patch level metrics are possible
to extract. Please be aware that the output is sligthly different to all
other \code{lsm}-function of \code{landscapemetrics}. Returns a tibble with chosen
metrics and the ID of the spatial objects.
}
\examples{
points <- matrix(c(10, 5, 25, 15, 5, 25), ncol = 2, byrow = TRUE)
extract_lsm(landscape, points)
extract_lsm(landscape, points, type = "aggregation metric")

points_sp <- sp::SpatialPoints(points)
extract_lsm(landscape, points, what = "lsm_p_area")

}
\seealso{
\code{\link{lsm_c_enn_mn}},
\code{\link{lsm_c_enn_sd}},
\code{\link{lsm_c_enn_cv}}, \cr
\code{\link{lsm_l_enn_mn}},
\code{\link{lsm_l_enn_sd}},
\code{\link{lsm_l_enn_cv}}
}
